/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.KeyValueUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class PreferenceLayer
implements IPreferenceProvider {
    private final IPreferenceProvider mBacking;
    private final Map<String, Object> mPreferenceOverlay;
    private final Class<?> mCreator;

    public PreferenceLayer(IPreferenceProvider backing, Class<?> creator) {
        this.mBacking = Objects.requireNonNull(backing);
        this.mPreferenceOverlay = new HashMap<String, Object>();
        this.mCreator = Objects.requireNonNull(creator);
    }

    public boolean getBoolean(String key) {
        return this.getFromOverlay(key, Boolean::parseBoolean, arg_0 -> ((IPreferenceProvider)this.mBacking).getBoolean(arg_0));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getFromOverlay(key, Boolean::parseBoolean, a -> this.mBacking.getBoolean(a, defaultValue));
    }

    public String getString(String key) {
        return this.getFromOverlay(key, t -> t, arg_0 -> ((IPreferenceProvider)this.mBacking).getString(arg_0));
    }

    public String getString(String key, String defaultValue) {
        return this.getFromOverlay(key, t -> t, a -> this.mBacking.getString(a, defaultValue));
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> clazz) {
        return (T)this.getFromOverlay(key, a -> Enum.valueOf(clazz, a), a -> this.mBacking.getEnum(a, clazz));
    }

    public <T extends Enum<T>> T getEnum(String key, T defaultValue, Class<T> clazz) {
        return (T)this.getFromOverlay(key, a -> Enum.valueOf(clazz, a), a -> this.mBacking.getEnum(a, defaultValue, clazz));
    }

    public byte[] getByteArray(String key) {
        return this.getFromOverlay(key, a -> a.getBytes(), arg_0 -> ((IPreferenceProvider)this.mBacking).getByteArray(arg_0));
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        return this.getFromOverlay(key, a -> a.getBytes(), a -> this.mBacking.getByteArray(a, defaultValue));
    }

    public double getDouble(String key) {
        return this.getFromOverlay(key, Double::parseDouble, arg_0 -> ((IPreferenceProvider)this.mBacking).getDouble(arg_0));
    }

    public double getDouble(String key, double defaultValue) {
        return this.getFromOverlay(key, Double::parseDouble, a -> this.mBacking.getDouble(a, defaultValue));
    }

    public float getFloat(String key) {
        return this.getFromOverlay(key, Float::parseFloat, arg_0 -> ((IPreferenceProvider)this.mBacking).getFloat(arg_0)).floatValue();
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFromOverlay(key, Float::parseFloat, a -> Float.valueOf(this.mBacking.getFloat(a, defaultValue))).floatValue();
    }

    public int getInt(String key) {
        return this.getFromOverlay(key, Integer::parseInt, arg_0 -> ((IPreferenceProvider)this.mBacking).getInt(arg_0));
    }

    public int getInt(String key, int defaultValue) {
        return this.getFromOverlay(key, Integer::parseInt, a -> this.mBacking.getInt(a, defaultValue));
    }

    public long getLong(String key) {
        return this.getFromOverlay(key, Long::parseLong, arg_0 -> ((IPreferenceProvider)this.mBacking).getLong(arg_0));
    }

    public long getLong(String key, long defaultValue) {
        return this.getFromOverlay(key, Long::parseLong, a -> this.mBacking.getLong(a, defaultValue));
    }

    public Map<String, String> getKeyValueMap(String key) {
        return this.getFromOverlay(key, KeyValueUtil::toMap, arg_0 -> ((IPreferenceProvider)this.mBacking).getKeyValueMap(arg_0));
    }

    public void put(String key, String value) {
        this.put(key, (Object)value);
    }

    public void put(String key, Object value) {
        this.mPreferenceOverlay.put(key, value);
    }

    private <T> T getFromOverlay(String key, Function<String, T> funStrToValue, Function<String, T> funFromBacking) {
        Object value = this.mPreferenceOverlay.get(key);
        if (value != null) {
            if (value instanceof String) {
                return funStrToValue.apply((String)value);
            }
            return (T)value;
        }
        return funFromBacking.apply(key);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " created by " + this.mCreator.getName() + " with " + this.mPreferenceOverlay.size() + " entries";
    }

    IPreferenceProvider getBacking() {
        return this.mBacking;
    }

    public String getSingleLinePreferenceString() {
        throw new UnsupportedOperationException("Overlays do not support showing all available settings");
    }
}

