/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;

final class ProgressAwareTimer
implements IProgressAwareTimer {
    private final IProgressAwareTimer mParent;
    private final long mDeadline;

    private ProgressAwareTimer(IProgressAwareTimer parent, long deadline) {
        if (deadline <= 0L && deadline != -1L) {
            throw new IllegalArgumentException("deadline must be positive or -1");
        }
        this.mParent = parent;
        this.mDeadline = deadline;
    }

    private boolean isTimeout() {
        if (this.mDeadline == -1L) {
            return false;
        }
        return System.currentTimeMillis() > this.mDeadline;
    }

    public boolean continueProcessing() {
        if (this.mParent == null) {
            return !this.isTimeout();
        }
        return !this.isTimeout() && this.mParent.continueProcessing();
    }

    public IProgressAwareTimer getTimer(long timeout) {
        return ProgressAwareTimer.createWithTimeout(null, timeout);
    }

    public IProgressAwareTimer getChildTimer(long timeout) {
        return ProgressAwareTimer.createWithTimeout(this, timeout);
    }

    public IProgressAwareTimer getChildTimer(double percentage) {
        return ProgressAwareTimer.createWithPercentage(this, percentage);
    }

    public long getDeadline() {
        return this.mDeadline;
    }

    static IProgressAwareTimer createWithTimeout(IProgressAwareTimer parent, long timeout) {
        return ProgressAwareTimer.createWithDeadline(parent, System.currentTimeMillis() + timeout);
    }

    static IProgressAwareTimer createWithDeadline(IProgressAwareTimer parent, long deadline) {
        return new ProgressAwareTimer(parent, deadline);
    }

    static IProgressAwareTimer createWithPercentage(IProgressAwareTimer parent, double percentage) {
        if (parent == null) {
            throw new IllegalArgumentException("parent may not be null");
        }
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("percentage must be larger than zero and smaller or equal to one, but was " + percentage);
        }
        if (parent.getDeadline() == -1L) {
            return ProgressAwareTimer.createWithDeadline(parent, -1L);
        }
        long current = System.currentTimeMillis();
        long currenttimeout = parent.getDeadline() - current;
        long newtimeout = (long)((double)currenttimeout * percentage);
        return ProgressAwareTimer.createWithDeadline(parent, current + newtimeout);
    }

    public IProgressAwareTimer getParent() {
        return this.mParent;
    }

    public long remainingTime() {
        long parentRemainingTime;
        if (this.mDeadline == -1L) {
            if (this.mParent != null) {
                return this.mParent.remainingTime();
            }
            return -1L;
        }
        long current = System.currentTimeMillis();
        long remainingTime = Math.max(0L, this.mDeadline - current);
        long l = parentRemainingTime = this.mParent == null ? -1L : this.mParent.remainingTime();
        if (parentRemainingTime == -1L) {
            return remainingTime;
        }
        return Math.min(remainingTime, parentRemainingTime);
    }
}

