/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainCancel;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;

public class ProgressMonitorService
implements IStorable,
IProgressMonitorService,
IProgressAwareTimer {
    private static final String STORAGE_KEY = "CancelNotificationService";
    private final IToolchainProgressMonitor mMonitor;
    private final ILogger mLogger;
    private final IToolchainCancel mToolchainCancel;
    private IProgressAwareTimer mTimer;
    private boolean mCancelRequest;

    public ProgressMonitorService(IToolchainProgressMonitor monitor, ILogger logger, IToolchainCancel cancel) {
        this.mMonitor = Objects.requireNonNull(monitor, "monitor may not be null");
        this.mLogger = Objects.requireNonNull(logger, "logger may not be null");
        this.mToolchainCancel = Objects.requireNonNull(cancel, "cancel may not be null");
        this.mCancelRequest = false;
    }

    public boolean continueProcessing() {
        boolean cancel;
        boolean bl = cancel = this.mMonitor.isCanceled() || this.mCancelRequest || this.isTimeout();
        if (cancel && this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Do not continue processing!");
        }
        return !cancel;
    }

    private boolean isTimeout() {
        return this.mTimer != null && !this.mTimer.continueProcessing();
    }

    public void setSubtask(String task) {
        this.mMonitor.subTask(task);
    }

    public void setDeadline(long deadline) {
        if (System.currentTimeMillis() >= deadline) {
            this.mLogger.warn((Object)String.format("Deadline was set to a date in the past, effectively stopping the toolchain. Is this what you intended? Value of date was %,d", deadline));
            deadline = -1L;
        }
        if (this.mTimer != null) {
            this.mLogger.warn((Object)"Replacing all timers with new deadline!");
        }
        this.mTimer = ProgressAwareTimer.createWithDeadline(null, deadline);
    }

    static ProgressMonitorService getService(IToolchainStorage storage) {
        assert (storage != null);
        return (ProgressMonitorService)storage.getStorable(STORAGE_KEY);
    }

    public static String getServiceKey() {
        return STORAGE_KEY;
    }

    public void destroy() {
        this.mMonitor.done();
    }

    public CountDownLatch cancelToolchain() {
        this.mCancelRequest = true;
        return this.mToolchainCancel.cancelToolchain();
    }

    public IProgressAwareTimer getTimer(long timeout) {
        return ProgressAwareTimer.createWithTimeout(null, timeout);
    }

    public IProgressAwareTimer getChildTimer(long timeout) {
        return ProgressAwareTimer.createWithTimeout(this, timeout);
    }

    public IProgressAwareTimer getChildTimer(double percentage) {
        return ProgressAwareTimer.createWithPercentage(this, percentage);
    }

    public long getDeadline() {
        if (this.mTimer == null) {
            return -1L;
        }
        return this.mTimer.getDeadline();
    }

    public IProgressAwareTimer getParent() {
        if (this.mTimer == null) {
            return null;
        }
        return this.mTimer.getParent();
    }

    public IUltimateServiceProvider registerChildTimer(IUltimateServiceProvider services, IProgressAwareTimer timer) {
        return ProgressMonitorService.registerChildTimer(this, services, timer);
    }

    public long remainingTime() {
        if (this.mTimer == null) {
            return -1L;
        }
        return this.mTimer.remainingTime();
    }

    private static IUltimateServiceProvider registerChildTimer(IProgressMonitorService parent, IUltimateServiceProvider services, IProgressAwareTimer timer) {
        if (timer == null) {
            throw new IllegalArgumentException("Cannot add null timer");
        }
        if (services == null) {
            throw new IllegalArgumentException("services is null");
        }
        return new UltimateServiceProviderLayer(services, new ProgressMonitorLayer(parent, timer));
    }

    private static final class ProgressMonitorLayer
    implements IProgressMonitorService {
        private final IProgressMonitorService mParent;
        private final IProgressAwareTimer mTimer;

        public ProgressMonitorLayer(IProgressMonitorService parent, IProgressAwareTimer timer) {
            this.mParent = Objects.requireNonNull(parent);
            this.mTimer = Objects.requireNonNull(timer);
        }

        public CountDownLatch cancelToolchain() {
            return this.mParent.cancelToolchain();
        }

        public long remainingTime() {
            return this.mTimer.remainingTime();
        }

        public IProgressAwareTimer getTimer(long timeout) {
            return ProgressAwareTimer.createWithTimeout(null, timeout);
        }

        public IProgressAwareTimer getChildTimer(long timeout) {
            return ProgressAwareTimer.createWithTimeout((IProgressAwareTimer)this, timeout);
        }

        public IProgressAwareTimer getChildTimer(double percentage) {
            return ProgressAwareTimer.createWithPercentage((IProgressAwareTimer)this, percentage);
        }

        public IProgressAwareTimer getParent() {
            return this.mTimer.getParent();
        }

        public long getDeadline() {
            return this.mTimer.getDeadline();
        }

        public boolean continueProcessing() {
            return this.mParent.continueProcessing() && this.mTimer.continueProcessing();
        }

        public void setSubtask(String task) {
            this.mParent.setSubtask(task);
        }

        public void setDeadline(long date) {
            this.mParent.setDeadline(date);
        }

        public IUltimateServiceProvider registerChildTimer(IUltimateServiceProvider services, IProgressAwareTimer timer) {
            return ProgressMonitorService.registerChildTimer(this, services, timer);
        }
    }

    private static final class UltimateServiceProviderLayer
    implements IUltimateServiceProvider {
        private final IUltimateServiceProvider mParent;
        private final IProgressMonitorService mProgressMonitorService;

        public UltimateServiceProviderLayer(IUltimateServiceProvider services, IProgressMonitorService progressMonitorService) {
            this.mParent = Objects.requireNonNull(services);
            this.mProgressMonitorService = Objects.requireNonNull(progressMonitorService);
        }

        public IUltimateServiceProvider registerPreferenceLayer(Class<?> creator, String ... pluginIds) {
            IUltimateServiceProvider newLayer = this.mParent.registerPreferenceLayer(creator, pluginIds);
            return new UltimateServiceProviderLayer(newLayer, this.mProgressMonitorService);
        }

        public IUltimateServiceProvider registerDefaultPreferenceLayer(Class<?> creator, String ... pluginIds) {
            IUltimateServiceProvider newLayer = this.mParent.registerDefaultPreferenceLayer(creator, pluginIds);
            return new UltimateServiceProviderLayer(newLayer, this.mProgressMonitorService);
        }

        public IToolchainStorage getStorage() {
            return this.mParent.getStorage();
        }

        public <T extends IService, K extends IServiceFactory<T>> T getServiceInstance(Class<K> serviceType) {
            return (T)this.mParent.getServiceInstance(serviceType);
        }

        public IResultService getResultService() {
            return this.mParent.getResultService();
        }

        public IProgressMonitorService getProgressMonitorService() {
            return this.mProgressMonitorService;
        }

        public IPreferenceProvider getPreferenceProvider(String pluginId) {
            return this.mParent.getPreferenceProvider(pluginId);
        }

        public ILoggingService getLoggingService() {
            return this.mParent.getLoggingService();
        }

        public IBacktranslationService getBacktranslationService() {
            return this.mParent.getBacktranslationService();
        }
    }
}

