/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithLocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class ResultService
implements IStorable,
IResultService {
    private final Map<String, List<IResult>> mResults = new HashMap<String, List<IResult>>();
    private final Map<String, Function<IResult, IResult>> mTransformers = new LinkedHashMap<String, Function<IResult, IResult>>();
    private static final String KEY = "ResultService";

    private ResultService() {
    }

    public void destroy() {
        this.mResults.clear();
        this.mTransformers.clear();
    }

    public Map<String, List<IResult>> getResults() {
        return this.mResults;
    }

    public void reportResult(String id, IResult origResult) {
        IResult transformedResult = this.applyTransformers(origResult);
        if (transformedResult == null) {
            return;
        }
        if (transformedResult instanceof IResultWithLocation && ((IResultWithLocation)transformedResult).getLocation() == null) {
            throw new IllegalArgumentException("Location is null");
        }
        if (transformedResult.getShortDescription() == null) {
            throw new IllegalArgumentException("ShortDescription is null");
        }
        if (transformedResult.getLongDescription() == null) {
            throw new IllegalArgumentException("LongDescription is null");
        }
        List<IResult> list = this.mResults.get(id);
        if (list == null) {
            list = new ArrayList<IResult>();
        }
        list.add(transformedResult);
        this.mResults.put(id, list);
    }

    private IResult applyTransformers(IResult origResult) {
        if (this.mTransformers.isEmpty()) {
            return origResult;
        }
        Iterator<Map.Entry<String, Function<IResult, IResult>>> iter = this.mTransformers.entrySet().iterator();
        IResult current = origResult;
        while (current != null && iter.hasNext()) {
            Map.Entry<String, Function<IResult, IResult>> currentTransformer = iter.next();
            if (currentTransformer.getValue() == null) continue;
            current = currentTransformer.getValue().apply(current);
        }
        return current;
    }

    static IResultService getService(IToolchainStorage storage) {
        assert (storage != null);
        IStorable rtr = storage.getStorable(KEY);
        if (rtr == null) {
            rtr = new ResultService();
            storage.putStorable(KEY, rtr);
        }
        return (IResultService)rtr;
    }

    public String toString() {
        if (this.mResults.isEmpty()) {
            return "No Results";
        }
        return this.mResults.toString();
    }

    public void registerTransformer(String name, UnaryOperator<IResult> resultTransformer) {
        this.mTransformers.put(name, resultTransformer);
    }
}

