/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.BacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.GenericServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.Log4JLoggingService;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.PreferenceLayer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ResultService;
import de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ToolchainStorage
implements IToolchainStorage,
IUltimateServiceProvider {
    private final Deque<Pair<Object, Set<String>>> mMarker;
    private final Map<String, IStorable> mToolchainStorage;
    private final Map<String, PreferenceLayer> mPreferenceLayers;
    private final Object mLock;

    public ToolchainStorage() {
        this(new LinkedHashMap<String, IStorable>(), new HashMap<String, PreferenceLayer>(), new ArrayDeque<Pair<Object, Set<String>>>(), new Object());
        this.pushMarker(this);
    }

    private ToolchainStorage(Map<String, IStorable> storage, Map<String, PreferenceLayer> layers, Deque<Pair<Object, Set<String>>> marker, Object lock) {
        this.mLock = Objects.requireNonNull(lock);
        this.mToolchainStorage = Objects.requireNonNull(storage);
        this.mPreferenceLayers = Objects.requireNonNull(layers);
        this.mMarker = Objects.requireNonNull(marker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStorable getStorable(String key) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mToolchainStorage.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStorable putStorable(String key, IStorable value) {
        if (value == null || key == null) {
            throw new IllegalArgumentException("Cannot store nothing");
        }
        Object object = this.mLock;
        synchronized (object) {
            Pair<Object, Set<String>> currentMarker = this.mMarker.peek();
            ((Set)currentMarker.getSecond()).add(key);
            return this.mToolchainStorage.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStorable removeStorable(String key) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mToolchainStorage.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            Collection<IStorable> values = this.mToolchainStorage.values();
            if (values.isEmpty()) {
                return;
            }
            ArrayList<IStorable> current = new ArrayList<IStorable>(values);
            if (current.isEmpty()) {
                return;
            }
            Collections.reverse(current);
            ILogger coreLogger = this.getLoggingService().getLogger("de.uni_freiburg.informatik.ultimate.core");
            if (coreLogger.isDebugEnabled()) {
                coreLogger.debug((Object)("Clearing " + current.size() + " storables from " + this.getClass().getSimpleName()));
            }
            for (IStorable storable : current) {
                if (storable == null) {
                    coreLogger.warn((Object)"Found NULL storable, ignoring");
                    continue;
                }
                try {
                    storable.destroy();
                }
                catch (Throwable t) {
                    if (coreLogger == null) continue;
                    coreLogger.fatal((Object)("There was an exception during clearing of toolchain storage while destroying " + storable.getClass().toString() + ": " + t.getMessage()));
                }
            }
            this.mToolchainStorage.clear();
            this.mMarker.clear();
            this.pushMarker(this);
        }
    }

    public boolean destroyStorable(String key) {
        IStorable storable = this.removeStorable(key);
        if (storable != null) {
            storable.destroy();
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mToolchainStorage.toString();
    }

    public IBacktranslationService getBacktranslationService() {
        return BacktranslationService.getService(this);
    }

    public ILoggingService getLoggingService() {
        return Log4JLoggingService.getService(this);
    }

    public IResultService getResultService() {
        return ResultService.getService(this);
    }

    public IProgressMonitorService getProgressMonitorService() {
        return ProgressMonitorService.getService(this);
    }

    public <T extends IService, K extends IServiceFactory<T>> T getServiceInstance(Class<K> serviceType) {
        return GenericServiceProvider.getServiceInstance(this, serviceType);
    }

    public IPreferenceProvider getPreferenceProvider(String pluginId) {
        PreferenceLayer layer = this.mPreferenceLayers.get(pluginId);
        if (layer != null) {
            return layer;
        }
        return new RcpPreferenceProvider(pluginId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUltimateServiceProvider registerPreferenceLayer(Class<?> creator, String ... pluginIds) {
        Object object = this.mLock;
        synchronized (object) {
            HashMap<String, PreferenceLayer> newLayers = new HashMap<String, PreferenceLayer>(this.mPreferenceLayers);
            if (pluginIds == null || pluginIds.length == 0) {
                return this;
            }
            String[] stringArray = pluginIds;
            int n = pluginIds.length;
            int n2 = 0;
            while (n2 < n) {
                String pluginId = stringArray[n2];
                PreferenceLayer existingLayer = (PreferenceLayer)newLayers.get(pluginId);
                PreferenceLayer newLayer = existingLayer != null ? new PreferenceLayer(existingLayer, creator) : new PreferenceLayer(this.getPreferenceProvider(pluginId), creator);
                newLayers.put(pluginId, newLayer);
                ++n2;
            }
            return new ToolchainStorage(this.mToolchainStorage, newLayers, this.mMarker, this.mLock);
        }
    }

    public IUltimateServiceProvider registerDefaultPreferenceLayer(Class<?> creator, String ... pluginIds) {
        IUltimateServiceProvider layer = this.registerPreferenceLayer(creator, pluginIds);
        String[] stringArray = pluginIds;
        int n = pluginIds.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginId = stringArray[n2];
            RcpPreferenceProvider prefProvider = new RcpPreferenceProvider(pluginId);
            IPreferenceProvider preferences = layer.getPreferenceProvider(pluginId);
            for (Map.Entry<String, Object> entry : prefProvider.getDefaultPreferences().entrySet()) {
                preferences.put(entry.getKey(), entry.getValue());
            }
            ++n2;
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keys() {
        HashSet<String> keys;
        Object object = this.mLock;
        synchronized (object) {
            keys = new HashSet<String>(this.mToolchainStorage.keySet());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMarker(Object marker) throws IllegalArgumentException {
        if (marker == null) {
            throw new IllegalArgumentException("marker may not be null");
        }
        if (this.hasMarker(marker)) {
            throw new IllegalArgumentException("duplicate marker");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mMarker.push((Pair<Object, Set<String>>)new Pair(marker, new HashSet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> destroyMarker(Object marker) {
        if (this.mMarker.isEmpty() || !this.hasMarker(marker)) {
            return Collections.emptySet();
        }
        Object object = this.mLock;
        synchronized (object) {
            HashSet<String> rtr = new HashSet<String>();
            Iterator<Pair<Object, Set<String>>> iter = this.mMarker.iterator();
            while (iter.hasNext()) {
                Pair<Object, Set<String>> markerPair = iter.next();
                iter.remove();
                for (String key : (Set)markerPair.getSecond()) {
                    if (!this.destroyStorable(key)) continue;
                    rtr.add(key);
                }
                if (markerPair.getFirst() != marker) continue;
                return rtr;
            }
            return rtr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMarker(Object marker) {
        assert (marker != null);
        Object object = this.mLock;
        synchronized (object) {
            return this.mMarker.stream().map(Pair::getFirst).anyMatch(a -> a == marker);
        }
    }

    public IToolchainStorage getStorage() {
        return this;
    }
}

