/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain;

import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class BasicToolchainJob
extends Job {
    protected ICore<RunDefinition> mCore;
    protected IController<RunDefinition> mController;
    protected ILogger mLogger;
    protected IUltimateServiceProvider mServices;
    private long mDeadline;

    protected BasicToolchainJob(String name, ICore<RunDefinition> core, IController<RunDefinition> controller, ILogger logger) {
        super(name);
        this.mCore = core;
        this.mController = controller;
        this.mLogger = Objects.requireNonNull(logger);
        this.mDeadline = -1L;
    }

    private void setTimeout() {
        long realDeadline = 0L;
        IPreferenceProvider ups = this.mServices.getPreferenceProvider("de.uni_freiburg.informatik.ultimate.core");
        int preferencesDeadline = ups.getInt("Toolchain timeout in seconds");
        realDeadline = this.mDeadline != -1L ? this.mDeadline : (long)preferencesDeadline * 1000L;
        if (realDeadline > 0L) {
            this.mServices.getProgressMonitorService().setDeadline(System.currentTimeMillis() + realDeadline);
        }
    }

    protected void setServices(IUltimateServiceProvider services) {
        this.mServices = services;
        this.setTimeout();
    }

    public void setDeadline(long deadline) {
        if (deadline >= 0L) {
            this.mDeadline = deadline;
        }
    }

    protected abstract IStatus run(IProgressMonitor var1);

    protected IStatus convert(IToolchain.ReturnCode result) {
        switch (result) {
            case Ok: 
            case Cancel: {
                return Status.OK_STATUS;
            }
        }
        return new Status(8, "de.uni_freiburg.informatik.ultimate.core", 4, result.toString(), null);
    }
}

