/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.RcpProgressMonitorWrapper;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.ParserInitializationException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain.BasicToolchainJob;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ExceptionOrErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DefaultToolchainJob
extends BasicToolchainJob {
    protected File[] mInputFiles;
    protected IToolchain<RunDefinition> mToolchain;

    public DefaultToolchainJob(String name, ICore<RunDefinition> core, IController<RunDefinition> controller, ILogger logger, File[] input) {
        super(name, core, controller, logger);
        this.setUser(true);
        this.setSystem(false);
        if (input == null || input.length == 0) {
            throw new IllegalArgumentException("No input files given");
        }
        this.mInputFiles = input;
    }

    public DefaultToolchainJob(String name, ICore<RunDefinition> core, IController<RunDefinition> controller, ILogger logger, IToolchain<RunDefinition> toolchain) {
        super(name, core, controller, logger);
        this.setUser(true);
        this.setSystem(false);
        this.setToolchain(toolchain);
    }

    protected void setToolchain(IToolchain<RunDefinition> toolchain) {
        assert (toolchain != null);
        this.mToolchain = toolchain;
    }

    protected void releaseToolchain() {
        this.mCore.releaseToolchain(this.mToolchain);
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        IToolchainProgressMonitor tpm = RcpProgressMonitorWrapper.create(monitor);
        tpm.beginTask(this.getName(), -1);
        try {
            this.setToolchain((IToolchain<RunDefinition>)this.mCore.requestToolchain(this.mInputFiles));
            tpm.worked(1);
            this.mToolchain.init(tpm);
            tpm.worked(1);
            if (!this.mToolchain.initializeParsers()) {
                throw new ParserInitializationException();
            }
            tpm.worked(1);
            IToolchainData chain = this.mToolchain.makeToolSelection(tpm);
            if (chain == null) {
                this.mLogger.fatal((Object)"Toolchain selection failed, aborting...");
                Status status = new Status(8, "de.uni_freiburg.informatik.ultimate.core", 8, "Toolchain selection canceled", null);
                return status;
            }
            this.setServices(chain.getServices());
            tpm.worked(1);
            this.mToolchain.runParsers();
            tpm.worked(1);
            IStatus iStatus = this.convert(this.mToolchain.processToolchain(tpm));
            return iStatus;
        }
        catch (Throwable e) {
            IStatus iStatus = this.handleException(e);
            return iStatus;
        }
        finally {
            tpm.done();
            this.releaseToolchain();
        }
    }

    protected IStatus handleException(Throwable e) {
        if (e == null) {
            this.mLogger.fatal((Object)"The toolchain wants to handle an exception, but provided nothing");
        } else if (this.mLogger.isDebugEnabled()) {
            this.mLogger.fatal((Object)"The toolchain threw an exception", e);
        } else {
            this.mLogger.fatal((Object)String.format("The toolchain threw an exception: %s: %s", e.getClass(), e.getMessage()));
        }
        this.mController.displayException(this.mToolchain.getCurrentToolchainData(), "The toolchain threw an exception", e);
        if (this.mServices != null) {
            this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new ExceptionOrErrorResult("de.uni_freiburg.informatik.ultimate.core", e));
        }
        return new Status(4, "de.uni_freiburg.informatik.ultimate.core", 4, "Toolchain threw an exception", null);
    }
}

