/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.RcpProgressMonitorWrapper;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain.BasicToolchainJob;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ExceptionOrErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExternalParserToolchainJob
extends BasicToolchainJob {
    private final IElement mAST;
    private final ModelType mOutputDefinition;

    public ExternalParserToolchainJob(String name, ICore<RunDefinition> core, IController<RunDefinition> controller, IElement ast, ModelType outputDefinition, ILogger logger) {
        super(name, core, controller, logger);
        this.mAST = ast;
        this.mOutputDefinition = outputDefinition;
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        IToolchainData chain;
        IToolchain currentToolchain;
        IStatus returnstatus;
        IToolchainProgressMonitor tpm;
        block5: {
            tpm = RcpProgressMonitorWrapper.create(monitor);
            returnstatus = Status.OK_STATUS;
            tpm.beginTask(this.getName(), -1);
            currentToolchain = null;
            tpm.worked(1);
            currentToolchain = this.mCore.requestToolchain(new File[0]);
            currentToolchain.init(tpm);
            tpm.worked(1);
            chain = currentToolchain.makeToolSelection(tpm);
            if (chain != null) break block5;
            this.mLogger.warn((Object)"Toolchain selection failed, aborting...");
            Status status = new Status(8, "de.uni_freiburg.informatik.ultimate.core", "Toolchain selection canceled");
            tpm.worked(1);
            this.releaseToolchain((IToolchain<RunDefinition>)currentToolchain);
            tpm.done();
            return status;
        }
        try {
            try {
                this.setServices(chain.getServices());
                tpm.worked(1);
                currentToolchain.addAST(this.mAST, this.mOutputDefinition);
                tpm.worked(1);
                returnstatus = this.convert(currentToolchain.processToolchain(tpm));
            }
            catch (Throwable e) {
                this.mLogger.fatal((Object)String.format("The toolchain threw an exception: %s", e.getMessage()));
                this.mLogger.fatal((Object)e);
                this.mController.displayException(currentToolchain.getCurrentToolchainData(), "The toolchain threw an exception", e);
                returnstatus = Status.CANCEL_STATUS;
                this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new ExceptionOrErrorResult("de.uni_freiburg.informatik.ultimate.core", e));
                tpm.worked(1);
                this.releaseToolchain((IToolchain<RunDefinition>)currentToolchain);
                tpm.done();
            }
        }
        catch (Throwable throwable) {
            tpm.worked(1);
            this.releaseToolchain(currentToolchain);
            tpm.done();
            throw throwable;
        }
        tpm.worked(1);
        this.releaseToolchain((IToolchain<RunDefinition>)currentToolchain);
        tpm.done();
        return returnstatus;
    }

    protected void releaseToolchain(IToolchain<RunDefinition> chain) {
        this.mCore.releaseToolchain(chain);
    }
}

