/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.RcpProgressMonitorWrapper;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.ParserInitializationException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain.DefaultToolchainJob;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RerunFreshToolchainJob
extends DefaultToolchainJob {
    private final IToolchainData<RunDefinition> mData;

    public RerunFreshToolchainJob(String name, ICore<RunDefinition> core, IController<RunDefinition> controller, ILogger logger, IToolchainData<RunDefinition> data, File[] files) {
        super(name, core, controller, logger, files);
        this.mData = data;
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        IToolchainProgressMonitor tpm = RcpProgressMonitorWrapper.create(monitor);
        tpm.beginTask(this.getName(), -1);
        try {
            this.setToolchain((IToolchain<RunDefinition>)this.mCore.requestToolchain(this.mInputFiles));
            tpm.worked(1);
            this.mToolchain.init(tpm);
            tpm.worked(1);
            if (!this.mToolchain.initializeParsers()) {
                throw new ParserInitializationException();
            }
            tpm.worked(1);
            IToolchainData data = this.mToolchain.setToolSelection(tpm, this.mData);
            if (data == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.setServices(data.getServices());
            tpm.worked(1);
            this.mToolchain.runParsers();
            tpm.worked(1);
            IStatus iStatus = this.convert(this.mToolchain.processToolchain(tpm));
            return iStatus;
        }
        catch (Throwable e) {
            IStatus iStatus = this.handleException(e);
            return iStatus;
        }
        finally {
            tpm.done();
            this.releaseToolchain();
        }
    }
}

