/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.preferences;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.PreferenceException;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.BaseUltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.KeyValueUtil;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import java.util.Map;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public final class RcpPreferenceBinder {
    private RcpPreferenceBinder() {
    }

    public static void initializePreferences(IEclipsePreferences preferenceStore, BaseUltimatePreferenceItem[] preferenceDescriptors) {
        RcpPreferenceBinder.flushEclipsePreferences(preferenceStore);
        for (BaseUltimatePreferenceItem prefItem : BaseUltimatePreferenceItem.constructFlattenedList((BaseUltimatePreferenceItem[])preferenceDescriptors)) {
            if (!(prefItem instanceof UltimatePreferenceItem)) continue;
            UltimatePreferenceItem item = (UltimatePreferenceItem)prefItem;
            String label = item.getLabel();
            Object value = item.getDefaultValue();
            preferenceStore.remove(label);
            switch (item.getType()) {
                case Boolean: {
                    preferenceStore.putBoolean(label, ((Boolean)value).booleanValue());
                    break;
                }
                case Integer: {
                    preferenceStore.putInt(label, ((Integer)value).intValue());
                    break;
                }
                case Double: {
                    preferenceStore.putDouble(label, ((Double)value).doubleValue());
                    break;
                }
                case Directory: 
                case String: 
                case Combo: 
                case Radio: 
                case Path: 
                case MultilineString: 
                case File: 
                case Color: {
                    preferenceStore.put(label, value.toString());
                    break;
                }
                case KeyValue: {
                    if (value instanceof Map) {
                        preferenceStore.put(label, KeyValueUtil.toKeyValueString((Map)((Map)value)));
                        break;
                    }
                    throw new IllegalArgumentException(String.format("Value %s is of type %s, but must be of type Map<String,String>", value, value.getClass()));
                }
                case Label: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("You need to implement the new enum type \"" + item.getType() + "\" here");
                }
            }
        }
        RcpPreferenceBinder.flushEclipsePreferences(preferenceStore);
    }

    public static IEclipsePreferences getInstanceStore(String pluginId) {
        return InstanceScope.INSTANCE.getNode(pluginId);
    }

    public static IEclipsePreferences getDefaultStore(String pluginId) {
        return DefaultScope.INSTANCE.getNode(pluginId);
    }

    public static void resetToDefaultPreferences(String pluginId, BaseUltimatePreferenceItem[] preferenceDescriptors) {
        IEclipsePreferences instanceStore = RcpPreferenceBinder.getInstanceStore(pluginId);
        RcpPreferenceBinder.initializePreferences(instanceStore, preferenceDescriptors);
    }

    public static void registerDefaultPreferences(String pluginId, BaseUltimatePreferenceItem[] preferenceDescriptors) {
        IEclipsePreferences instanceStore = RcpPreferenceBinder.getDefaultStore(pluginId);
        RcpPreferenceBinder.initializePreferences(instanceStore, preferenceDescriptors);
    }

    private static void flushEclipsePreferences(IEclipsePreferences prefs) {
        try {
            prefs.flush();
            prefs.sync();
        }
        catch (BackingStoreException e) {
            throw new PreferenceException("de.uni_freiburg.informatik.ultimate.core", (Throwable)e);
        }
    }
}

