/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.preferences;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.PreferenceException;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.KeyValueUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UnknownFormatConversionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class RcpPreferenceProvider
implements IPreferenceProvider {
    private final String mPluginID;
    private static final Map<String, Set<IEclipsePreferences.IPreferenceChangeListener>> ACTIVE_LISTENER = new HashMap<String, Set<IEclipsePreferences.IPreferenceChangeListener>>();

    public RcpPreferenceProvider(String pluginID) {
        this.mPluginID = pluginID;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getInstance().getBoolean(key, this.getDefault().getBoolean(key, defaultValue));
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String defaultValue) {
        return this.getInstance().get(key, this.getDefault().get(key, defaultValue));
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumType) {
        String strValue = this.getString(key);
        if (strValue.isEmpty()) {
            throw new UnknownFormatConversionException("An empty string cannot be converted to type " + enumType);
        }
        return Enum.valueOf(enumType, strValue);
    }

    public <T extends Enum<T>> T getEnum(String key, T defaultValue, Class<T> enumType) {
        String strValue = this.getString(key);
        if (strValue.isEmpty()) {
            return defaultValue;
        }
        return Enum.valueOf(enumType, strValue);
    }

    public byte[] getByteArray(String key) {
        return this.getByteArray(key, new byte[0]);
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        return this.getInstance().getByteArray(key, this.getDefault().getByteArray(key, defaultValue));
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        return this.getInstance().getDouble(key, this.getDefault().getDouble(key, defaultValue));
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getInstance().getFloat(key, this.getDefault().getFloat(key, defaultValue));
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        return this.getInstance().getInt(key, this.getDefault().getInt(key, defaultValue));
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        return this.getInstance().getLong(key, this.getDefault().getLong(key, defaultValue));
    }

    public Map<String, String> getKeyValueMap(String key) {
        return KeyValueUtil.toMap((String)this.getString(key, ""));
    }

    public void put(String key, String value) {
        this.getInstance().put(key, value);
        try {
            this.getInstance().flush();
        }
        catch (BackingStoreException e) {
            throw new PreferenceException(this.mPluginID, (Throwable)e);
        }
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener) {
        RcpPreferenceProvider.addPreferenceChangeListener(this.mPluginID, preferenceChangeListener);
    }

    private static void addPreferenceChangeListener(String id, IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener) {
        InstanceScope.INSTANCE.getNode(id).addPreferenceChangeListener(iPreferenceChangeListener);
        Set<IEclipsePreferences.IPreferenceChangeListener> set = ACTIVE_LISTENER.get(id);
        if (set == null) {
            set = new HashSet<IEclipsePreferences.IPreferenceChangeListener>();
            ACTIVE_LISTENER.put(id, set);
        }
        set.add(iPreferenceChangeListener);
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener) {
        this.getInstance().removePreferenceChangeListener(iPreferenceChangeListener);
        if (ACTIVE_LISTENER.containsKey(this.mPluginID)) {
            ACTIVE_LISTENER.get(this.mPluginID).remove(iPreferenceChangeListener);
        }
    }

    public IEclipsePreferences getDefaultEclipsePreferences() {
        return this.getDefault();
    }

    public IEclipsePreferences getEclipsePreferences() {
        return this.getInstance();
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public void exportPreferences(OutputStream outputStream) throws CoreException {
        Platform.getPreferencesService().exportPreferences(this.getInstance(), outputStream, null);
    }

    public static IStatus importPreferences(InputStream inputStream) throws CoreException {
        IStatus status = Platform.getPreferencesService().importPreferences(inputStream);
        if (status.isOK()) {
            for (Map.Entry<String, Set<IEclipsePreferences.IPreferenceChangeListener>> entry : ACTIVE_LISTENER.entrySet()) {
                for (IEclipsePreferences.IPreferenceChangeListener listener : entry.getValue()) {
                    InstanceScope.INSTANCE.getNode(entry.getKey()).removePreferenceChangeListener(listener);
                    RcpPreferenceProvider.addPreferenceChangeListener(entry.getKey(), listener);
                }
            }
        }
        return status;
    }

    public String[] getDeltaPreferencesStrings() {
        ArrayList<String> rtr = new ArrayList<String>();
        try {
            IEclipsePreferences defaults = this.getDefault();
            IEclipsePreferences instance = this.getInstance();
            String[] stringArray = defaults.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String defaultKey = stringArray[n2];
                String defaultValue = defaults.get(defaultKey, "NO DEFAULT SET");
                String currentValue = instance.get(defaultKey, defaultValue);
                if (!currentValue.equals(defaultValue)) {
                    rtr.add(String.valueOf(defaultKey) + "=" + currentValue);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            throw new PreferenceException(this.mPluginID, (Throwable)e);
        }
        return rtr.toArray(new String[rtr.size()]);
    }

    public Map<String, Object> getDefaultPreferences() {
        HashMap<String, Object> rtr = new HashMap<String, Object>();
        try {
            IEclipsePreferences defaults = this.getDefault();
            String[] stringArray = defaults.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String defaultKey = stringArray[n2];
                String defaultValue = defaults.get(defaultKey, null);
                rtr.put(defaultKey, defaultValue);
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            throw new PreferenceException(this.mPluginID, (Throwable)e);
        }
        return rtr;
    }

    public String getSingleLinePreferenceString() {
        StringBuilder sb = new StringBuilder();
        try {
            IEclipsePreferences instancePrefs = this.getInstance();
            IEclipsePreferences defaultPrefs = this.getDefault();
            String[] stringArray = defaultPrefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String prefKey = stringArray[n2];
                String activeValue = instancePrefs.get(prefKey, defaultPrefs.get(prefKey, null));
                sb.append(prefKey).append('=').append((Object)activeValue).append(" \u2666 ");
                ++n2;
            }
            sb.setLength(Math.max(0, sb.length() - " \u2666 ".length()));
        }
        catch (BackingStoreException e) {
            throw new PreferenceException(this.mPluginID, (Throwable)e);
        }
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(this.mPluginID) + " UltimatePreferenceStore";
    }

    private IEclipsePreferences getInstance() {
        return InstanceScope.INSTANCE.getNode(this.mPluginID);
    }

    private IEclipsePreferences getDefault() {
        return DefaultScope.INSTANCE.getNode(this.mPluginID);
    }

    public void put(String key, Object value) {
        if (value == null) {
            this.put(key, null);
        } else {
            this.put(key, value.toString());
        }
    }
}

