/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.util;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.UncheckedURISyntaxException;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Dictionary;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class RcpUtils {
    private RcpUtils() {
    }

    public static String getVersion(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return "UNKNOWN";
        }
        Dictionary headers = bundle.getHeaders();
        if (headers != null) {
            return (String)headers.get("Bundle-Version");
        }
        return "UNKNOWN";
    }

    public static File getWorkingDirectory() {
        try {
            return URIUtil.toFile((URI)Platform.getInstallLocation().getURL().toURI());
        }
        catch (URISyntaxException e) {
            throw new UncheckedURISyntaxException(e);
        }
    }

    public static String getInstanceLocationPath() {
        URL url;
        Location instloc = Platform.getInstanceLocation();
        if (instloc != null && (url = instloc.getURL()) != null) {
            return url.getPath();
        }
        return null;
    }

    public static String[] getFrameworkArguments() {
        EnvironmentInfo envInfo = RcpUtils.getEnvironmentInfo();
        return envInfo.getFrameworkArgs();
    }

    public static EnvironmentInfo getEnvironmentInfo() {
        BundleContext bc = Platform.getBundle((String)"de.uni_freiburg.informatik.ultimate.core").getBundleContext();
        if (bc == null) {
            return null;
        }
        ServiceReference infoRef = bc.getServiceReference(EnvironmentInfo.class.getName());
        if (infoRef == null) {
            return null;
        }
        EnvironmentInfo envInfo = (EnvironmentInfo)bc.getService(infoRef);
        if (envInfo == null) {
            return null;
        }
        bc.ungetService(infoRef);
        return envInfo;
    }

    public static ReflectionUtil.UrlConverter getBundleProtocolResolver() {
        return url -> FileLocator.toFileURL((URL)url);
    }
}

