/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.models;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IVisualizable;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public interface IDirectedGraph<T extends IDirectedGraph<T, E>, E extends IVisualizable<E>>
extends IElement,
IWalkable,
IVisualizable<E> {
    public List<T> getIncomingNodes();

    public List<T> getOutgoingNodes();

    default public Set<T> transitiveNodes(Function<T, Collection<T>> direction) {
        return IDirectedGraph.transitiveNodes(Collections.singleton(this), direction);
    }

    public static <N extends IDirectedGraph<N, ?>> Set<N> transitiveNodes(Collection<N> startingNodes, Function<N, Collection<N>> direction) {
        HashSet<IDirectedGraph> transitiveNodes = new HashSet<IDirectedGraph>();
        ArrayDeque<Object> newNodes = new ArrayDeque<Object>();
        newNodes.addAll(startingNodes);
        while (!newNodes.isEmpty()) {
            for (IDirectedGraph trans : direction.apply((IDirectedGraph)newNodes.remove())) {
                if (!transitiveNodes.add(trans)) continue;
                newNodes.add(trans);
            }
        }
        return transitiveNodes;
    }
}

