/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.models;

import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ModelType
implements Serializable {
    private static final long serialVersionUID = -2922069733243189149L;
    private int mSize;
    private final String mCreator;
    private Date mCreated;
    private long mLastModified;
    private String mLastModifier;
    private final Type mType;
    private int mIteration;
    private boolean mTouched;
    private final List<String> mFileNames;
    private DateFormat mLastModifiedStringFormat;
    private boolean mIsCyclic;
    private boolean mIsDirected;
    private boolean mIsTree;
    private boolean mIsOrdered;
    private boolean mIsMultiGraph;
    private boolean mIsFinite;

    public ModelType(String creatorPluginID, Type type, Collection<String> fileNames) {
        if (fileNames == null) {
            throw new IllegalArgumentException("A graphtype has to have at least one filename");
        }
        if (type == null) {
            throw new IllegalArgumentException("A graphtype has to have a type");
        }
        this.mCreator = creatorPluginID;
        this.mType = type;
        this.mFileNames = new ArrayList<String>(fileNames);
        this.init();
    }

    public void modified(String modifierPluginID) {
        this.setDirty(true);
        this.mLastModifier = modifierPluginID;
        this.mLastModified = System.currentTimeMillis();
        ++this.mIteration;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelType) {
            ModelType t = (ModelType)obj;
            return t.mLastModified == this.mLastModified && t.mCreator.equals(this.mCreator);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.mLastModified;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String fileName : this.mFileNames) {
            sb.append(new File(fileName).getName());
        }
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(this.mCreator);
        sb.append(" " + (Object)((Object)this.mType));
        sb.append(" " + this.mLastModifiedStringFormat.format(new Date(this.mLastModified)));
        return sb.toString();
    }

    public boolean isDirty() {
        return this.mTouched;
    }

    public void setDirty(boolean flag) {
        this.mTouched = flag;
    }

    public String getCreator() {
        return this.mCreator;
    }

    public Date getCreated() {
        return this.mCreated;
    }

    public String getLastModifier() {
        return this.mLastModifier;
    }

    public Date getLastModified() {
        return new Date(this.mLastModified);
    }

    public boolean isFromSource() {
        return this.mIteration == 0;
    }

    public Type getType() {
        return this.mType;
    }

    public boolean isCyclic() {
        return this.mIsCyclic;
    }

    public boolean isDirected() {
        return this.mIsDirected;
    }

    public boolean isGraph() {
        return this.mIsTree;
    }

    public boolean isOrdered() {
        return this.mIsOrdered;
    }

    public boolean isFinite() {
        return this.mIsFinite;
    }

    public boolean isMulitGraph() {
        return this.mIsMultiGraph;
    }

    public String getAbsolutePath(int i) {
        return this.mFileNames.get(i);
    }

    public String getFileName(int i) {
        String s = this.mFileNames.get(i);
        if (s.contains(", ")) {
            String[] names = s.split(", ");
            s = "";
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                s = String.valueOf(s) + k.substring(k.lastIndexOf(File.separator) + 1) + ", ";
                ++n2;
            }
            s = s.substring(0, s.length() - 2);
        } else {
            s = s.trim();
            s = s.substring(s.lastIndexOf(File.separator) + 1);
        }
        return s;
    }

    public int getNumberOfFiles() {
        return this.mFileNames.size();
    }

    private void init() {
        this.mTouched = false;
        this.mIteration = 0;
        this.mLastModifier = this.mCreator;
        this.mCreated = new Date();
        this.mLastModified = System.currentTimeMillis();
        this.mSize = 0;
        this.mLastModifiedStringFormat = new SimpleDateFormat("dd.MM hh:mm:ss");
        this.setAttributes();
    }

    private void setAttributes() {
        switch (this.mType) {
            case AST: {
                this.mIsCyclic = false;
                this.mIsDirected = true;
                this.mIsTree = true;
                this.mIsOrdered = true;
                this.mIsMultiGraph = false;
                this.mIsFinite = true;
                break;
            }
            case CST: {
                this.mIsCyclic = false;
                this.mIsDirected = true;
                this.mIsTree = true;
                this.mIsOrdered = true;
                this.mIsMultiGraph = false;
                this.mIsFinite = true;
                break;
            }
            case DFG: {
                this.mIsCyclic = false;
                this.mIsDirected = true;
                this.mIsTree = true;
                this.mIsOrdered = false;
                this.mIsMultiGraph = false;
                this.mIsFinite = true;
                break;
            }
            case CFG: {
                this.mIsCyclic = true;
                this.mIsDirected = true;
                this.mIsTree = false;
                this.mIsOrdered = false;
                this.mIsMultiGraph = false;
                this.mIsFinite = true;
                break;
            }
            case OTHER: {
                this.mIsCyclic = true;
                this.mIsDirected = true;
                this.mIsTree = false;
                this.mIsOrdered = false;
                this.mIsMultiGraph = true;
                this.mIsFinite = false;
                break;
            }
        }
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    public List<String> getFileNames() {
        return this.mFileNames;
    }

    public static enum Type {
        AST,
        CG,
        CFG,
        DFG,
        CST,
        TS,
        PG,
        OTHER,
        CORRECTNESS_WITNESS,
        VIOLATION_WITNESS;

    }
}

