/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.models;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ModelUtils {
    private ModelUtils() {
    }

    public static void copyAnnotations(IElement oldE, IElement newE) {
        ModelUtils.copyAnnotationsFiltered(oldE, newE, a -> true);
    }

    public static void mergeAnnotations(Collection<? extends IElement> oldElem, IElement newElem) {
        if (oldElem == null || newElem == null) {
            return;
        }
        List oldElemAnnots = oldElem.stream().map(ModelUtils::getAnnotations).filter(a -> a != null).flatMap(a -> a.entrySet().stream()).collect(Collectors.toList());
        Map<String, IAnnotations> newElemAnnots = newElem.getPayload().getAnnotations();
        for (Map.Entry oldElemAnnot : oldElemAnnots) {
            String key = (String)oldElemAnnot.getKey();
            IAnnotations oldNewElemAnnot = newElemAnnots.get(key);
            if (oldNewElemAnnot != null) {
                IAnnotations mergedAnnotation = oldNewElemAnnot.merge((IAnnotations)oldElemAnnot.getValue());
                if (mergedAnnotation == null) continue;
                newElemAnnots.put(key, mergedAnnotation);
                continue;
            }
            newElemAnnots.put(key, (IAnnotations)oldElemAnnot.getValue());
        }
    }

    public static void mergeAnnotations(IElement newElem, IElement ... oldElements) {
        if (oldElements == null || oldElements.length == 0) {
            return;
        }
        ModelUtils.mergeAnnotations(Arrays.asList(oldElements), newElem);
    }

    public static <E extends IAnnotations> void copyAnnotations(IElement oldE, IElement newE, Class<E> annotation) {
        if (oldE == null || newE == null || annotation == null) {
            return;
        }
        ModelUtils.copyAnnotationsFiltered(oldE, newE, a -> annotation.isAssignableFrom(a.getClass()));
    }

    public static void copyAnnotationsExcept(IElement oldE, IElement newE, Class<?> ... clazzes) {
        if (clazzes == null || clazzes.length == 0) {
            ModelUtils.copyAnnotations(oldE, newE);
            return;
        }
        ModelUtils.copyAnnotationsFiltered(oldE, newE, a -> !Arrays.stream(clazzes).anyMatch(b -> b.isAssignableFrom(a.getClass())));
    }

    public static void copyAnnotationsFiltered(IElement oldE, IElement newE, Predicate<IAnnotations> filter) {
        Map<String, IAnnotations> oldAnnots = ModelUtils.getAnnotations(oldE);
        if (oldAnnots == null) {
            return;
        }
        Map<String, IAnnotations> newAnnots = newE.getPayload().getAnnotations();
        for (Map.Entry<String, IAnnotations> oldAnnot : oldAnnots.entrySet()) {
            IAnnotations mergedAnnot;
            IAnnotations replacedValue;
            if (!filter.test(oldAnnot.getValue()) || (replacedValue = newAnnots.put(oldAnnot.getKey(), oldAnnot.getValue())) == null || (mergedAnnot = replacedValue.merge(oldAnnot.getValue())) == null) continue;
            newAnnots.put(oldAnnot.getKey(), mergedAnnot);
        }
    }

    public static void consumeAnnotations(IElement elem, Consumer<Map.Entry<String, IAnnotations>> funConsumer) {
        Map<String, IAnnotations> annots = ModelUtils.getAnnotations(elem);
        if (annots == null) {
            return;
        }
        annots.entrySet().stream().forEach(funConsumer);
    }

    public static <T extends IAnnotations> T getAnnotation(IElement node, String key, Function<IAnnotations, T> funCast) {
        IAnnotations annot;
        IPayload payload;
        if (node == null) {
            return null;
        }
        if (node.hasPayload() && (payload = node.getPayload()).hasAnnotation() && (annot = payload.getAnnotations().get(key)) != null) {
            return (T)((IAnnotations)funCast.apply(annot));
        }
        return null;
    }

    private static Map<String, IAnnotations> getAnnotations(IElement elem) {
        if (elem == null) {
            return null;
        }
        if (!elem.hasPayload()) {
            return null;
        }
        IPayload oldPayload = elem.getPayload();
        if (oldPayload.hasAnnotation()) {
            return oldPayload.getAnnotations();
        }
        return null;
    }
}

