/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.preferences;

import java.util.LinkedHashMap;
import java.util.Map;

public final class KeyValueUtil {
    private static final String PAIR_SEPARATOR = ";";
    private static final String KV_SEPARATOR = "=";

    private KeyValueUtil() {
    }

    public static String toKeyValueString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = KeyValueUtil.check(entry.getKey());
            String value = KeyValueUtil.check(entry.getValue());
            sb.append(key).append(KV_SEPARATOR).append(value).append(PAIR_SEPARATOR);
        }
        return sb.toString();
    }

    private static String check(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Key or value cannot be null");
        }
        if (s.contains(PAIR_SEPARATOR)) {
            throw new IllegalArgumentException(String.format("Key or value cannot contain %s", PAIR_SEPARATOR));
        }
        if (s.contains(KV_SEPARATOR)) {
            throw new IllegalArgumentException(String.format("Key or value cannot contain %s", KV_SEPARATOR));
        }
        return s;
    }

    public static Map<String, String> toMap(String str) {
        if (str == null || str.isEmpty()) {
            return new LinkedHashMap<String, String>();
        }
        String[] keyvaluepairs = str.split(PAIR_SEPARATOR);
        if (keyvaluepairs == null || keyvaluepairs.length == 0) {
            return new LinkedHashMap<String, String>();
        }
        LinkedHashMap<String, String> rtr = new LinkedHashMap<String, String>();
        String[] stringArray = keyvaluepairs;
        int n = keyvaluepairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            if (KV_SEPARATOR.equals(pair)) {
                rtr.put("", "");
            } else {
                String[] kvp = pair.split(KV_SEPARATOR);
                if (kvp.length != 2) {
                    throw new IllegalArgumentException(String.format("String %s is not of the form key=value", pair));
                }
                rtr.put(kvp[0], kvp[1]);
            }
            ++n2;
        }
        return rtr;
    }

    public static String toKeyValueString(Object[] values) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object val = objectArray[n2];
            String[] kvp = String.valueOf(val).split(KV_SEPARATOR);
            if (kvp.length == 0) {
                sb.append(KV_SEPARATOR).append(PAIR_SEPARATOR);
            } else if (kvp.length == 2) {
                sb.append(KeyValueUtil.check(kvp[0])).append(KV_SEPARATOR).append(KeyValueUtil.check(kvp[1])).append(PAIR_SEPARATOR);
            } else {
                throw new IllegalArgumentException(String.format("Object %s is not of the form key=value", val));
            }
            ++n2;
        }
        return sb.toString();
    }

    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        if (s.contains(PAIR_SEPARATOR)) {
            return false;
        }
        return !s.contains(KV_SEPARATOR);
    }

    public static boolean isValid(Map.Entry<String, String> entry) {
        return KeyValueUtil.isValid(entry.getKey()) && KeyValueUtil.isValid(entry.getValue());
    }
}

