/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.preferences;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.BaseUltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.PreferenceType;
import java.util.ArrayList;
import java.util.List;

public final class UltimatePreferenceItem<T>
extends BaseUltimatePreferenceItem {
    private final String mLabel;
    private final T mDefaultValue;
    private final PreferenceType mType;
    private final T[] mChoices;
    private final IUltimatePreferenceItemValidator<T> mPreferenceValidator;
    private final String mToolTip;

    public UltimatePreferenceItem(String label, T defaultValue, PreferenceType type) {
        this(label, defaultValue, type, null, false, null, null);
    }

    public UltimatePreferenceItem(String label, T defaultValue, PreferenceType type, T[] choices, IUltimatePreferenceItemValidator<T> preferenceValidator) {
        this(label, defaultValue, type, null, false, choices, preferenceValidator);
    }

    public UltimatePreferenceItem(String label, T defaultValue, PreferenceType type, T[] choices) {
        this(label, defaultValue, type, null, false, choices, null);
    }

    public UltimatePreferenceItem(String label, T defaultValue, String desc, PreferenceType type, T[] choices) {
        this(label, defaultValue, type, desc, false, choices, null);
    }

    public UltimatePreferenceItem(String label, T defaultValue, PreferenceType type, IUltimatePreferenceItemValidator<T> preferenceValidator) {
        this(label, defaultValue, type, null, false, null, preferenceValidator);
    }

    public UltimatePreferenceItem(String label, T defaultValue, String tooltip, PreferenceType type) {
        this(label, defaultValue, type, tooltip, false, null, null);
    }

    public UltimatePreferenceItem(String label, T defaultValue, String tooltip, PreferenceType type, IUltimatePreferenceItemValidator<T> preferenceValidator) {
        this(label, defaultValue, type, tooltip, false, null, preferenceValidator);
    }

    public UltimatePreferenceItem(String label, T defaultValue, PreferenceType type, String tooltip, boolean useCustomPreferencePage, T[] choices, IUltimatePreferenceItemValidator<T> preferenceValidator) {
        this.mLabel = label;
        this.mDefaultValue = defaultValue;
        this.mType = type;
        this.mChoices = choices;
        this.mUseCustomPreferencePage = useCustomPreferencePage;
        this.mPreferenceValidator = preferenceValidator;
        this.mToolTip = tooltip;
        if ((this.mType == PreferenceType.Radio || this.mType == PreferenceType.Combo) && this.mChoices == null) {
            throw new IllegalArgumentException("You have to supply choices if you use PreferenceType Radio or Combo ");
        }
    }

    public String getLabel() {
        return this.mLabel;
    }

    public T getDefaultValue() {
        return this.mDefaultValue;
    }

    @Override
    public PreferenceType getType() {
        return this.mType;
    }

    public T[] getChoices() {
        return this.mChoices;
    }

    public String[][] getComboFieldEntries() {
        String[][] rtr = new String[this.mChoices.length][2];
        int i = 0;
        while (i < this.mChoices.length) {
            rtr[i][0] = this.mChoices[i].toString();
            rtr[i][1] = rtr[i][0];
            ++i;
        }
        return rtr;
    }

    public String getToolTip() {
        return this.mToolTip;
    }

    public String toString() {
        return "Pref: " + this.mLabel + " Type=" + (Object)((Object)this.mType) + ", Default=" + this.mDefaultValue;
    }

    public IUltimatePreferenceItemValidator<T> getPreferenceValidator() {
        return this.mPreferenceValidator;
    }

    @Override
    public List<UltimatePreferenceItem<?>> getFlattenedList() {
        ArrayList returnList = new ArrayList();
        returnList.add(this);
        return returnList;
    }

    public static interface IUltimatePreferenceItemValidator<T> {
        public static final IntegerValidator ONLY_POSITIVE = new IntegerValidator(0, Integer.MAX_VALUE);
        public static final IntegerValidator ONLY_POSITIVE_NON_ZERO = new IntegerValidator(1, Integer.MAX_VALUE);
        public static final IntegerValidator GEQ_TWO = new IntegerValidator(2, Integer.MAX_VALUE);

        public boolean isValid(T var1);

        public String getInvalidValueErrorMessage(T var1);

        public static class DoubleValidator
        implements IUltimatePreferenceItemValidator<Double> {
            private final double mMin;
            private final double mMax;

            public DoubleValidator(double min, double max) {
                this.mMin = min;
                this.mMax = max;
            }

            @Override
            public boolean isValid(Double value) {
                return this.mMin <= value && value <= this.mMax;
            }

            @Override
            public String getInvalidValueErrorMessage(Double value) {
                return "Valid range is " + this.mMin + " <= value <= " + this.mMax;
            }
        }

        public static class IntegerValidator
        implements IUltimatePreferenceItemValidator<Integer> {
            private final int mMin;
            private final int mMax;

            public IntegerValidator(int min, int max) {
                this.mMin = min;
                this.mMax = max;
            }

            @Override
            public boolean isValid(Integer value) {
                return this.mMin <= value && value <= this.mMax;
            }

            @Override
            public String getInvalidValueErrorMessage(Integer value) {
                return "Valid range is " + this.mMin + " <= value <= " + this.mMax;
            }
        }
    }
}

