/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.services;

public interface ILogger {
    default public boolean isFatalEnabled() {
        return this.isLogLevelEnabled(LogLevel.FATAL);
    }

    public void fatal(Object var1, Throwable var2);

    default public void fatal(Object msg) {
        this.log(LogLevel.FATAL, msg);
    }

    default public void fatal(String formatString, Object ... formatArgs) {
        this.log(LogLevel.FATAL, formatString, formatArgs);
    }

    default public boolean isErrorEnabled() {
        return this.isLogLevelEnabled(LogLevel.ERROR);
    }

    public void error(Object var1, Throwable var2);

    default public void error(Object msg) {
        this.log(LogLevel.ERROR, msg);
    }

    default public void error(String formatString, Object ... formatArgs) {
        this.log(LogLevel.ERROR, formatString, formatArgs);
    }

    default public boolean isWarnEnabled() {
        return this.isLogLevelEnabled(LogLevel.WARN);
    }

    default public void warn(Object msg) {
        this.log(LogLevel.WARN, msg);
    }

    default public void warn(String formatString, Object ... formatArgs) {
        this.log(LogLevel.WARN, formatString, formatArgs);
    }

    default public boolean isInfoEnabled() {
        return this.isLogLevelEnabled(LogLevel.INFO);
    }

    default public void info(Object msg) {
        this.log(LogLevel.INFO, msg);
    }

    default public void info(String formatString, Object ... formatArgs) {
        this.log(LogLevel.INFO, formatString, formatArgs);
    }

    default public boolean isDebugEnabled() {
        return this.isLogLevelEnabled(LogLevel.DEBUG);
    }

    default public void debug(Object msg) {
        this.log(LogLevel.DEBUG, msg);
    }

    default public void debug(String formatString, Object ... formatArgs) {
        this.log(LogLevel.DEBUG, formatString, formatArgs);
    }

    public boolean isLogLevelEnabled(LogLevel var1);

    public void log(LogLevel var1, String var2);

    default public void log(LogLevel level, Object msg) {
        if (this.isLogLevelEnabled(level)) {
            this.log(level, msg.toString());
        }
    }

    default public void log(LogLevel level, String formatString, Object ... formatArgs) {
        if (this.isLogLevelEnabled(level)) {
            this.log(level, String.format(formatString, formatArgs));
        }
    }

    public void setLevel(LogLevel var1);

    public static ILogger getLogger(String loggerName) {
        throw new UnsupportedOperationException("You should never use the static logger method getLogger(String)! " + loggerName);
    }

    public static ILogger getDummyLogger() {
        return new ILogger(){

            @Override
            public void setLevel(LogLevel level) {
            }

            @Override
            public void log(LogLevel level, String message) {
            }

            @Override
            public boolean isLogLevelEnabled(LogLevel level) {
                return false;
            }

            @Override
            public void fatal(Object msg, Throwable t) {
            }

            @Override
            public void error(Object msg, Throwable t) {
            }
        };
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL,
        OFF;

    }
}

