/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.translation;

import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IToString;
import java.util.EnumSet;
import java.util.Objects;

public class AtomicTraceElement<TE> {
    private final TE mElement;
    private final TE mStep;
    private final IToString<TE> mToStringFunc;
    private final EnumSet<StepInfo> mStepInfo;
    private final IRelevanceInformation mRelevanceInformation;
    private final String mPrecedingProcedure;
    private final String mSucceedingProcedure;
    private final Integer mThreadId;
    private final Integer mForkedThreadId;

    private AtomicTraceElement(TE element, TE step, EnumSet<StepInfo> info, IToString<TE> toStringProvider, IRelevanceInformation relInfo, String precedingProcedure, String succeedingProcedure, Integer threadId, Integer forkedThreadId) {
        assert (element != null);
        assert (step != null);
        assert (info != null);
        assert (toStringProvider != null);
        assert (info.size() <= 1 || !info.contains((Object)StepInfo.NONE)) : "You cannot combine NONE with other values: " + element;
        assert (info.size() > 0);
        assert (!info.contains((Object)StepInfo.FORK) || forkedThreadId != null) : "If this step is a fork, you must have a forked thread id: " + element;
        assert (AtomicTraceElement.hasAnyStepInfo(info, StepInfo.PROC_CALL, StepInfo.PROC_RETURN) || threadId != null || Objects.equals(precedingProcedure, succeedingProcedure)) : "You must have same procedures except when you have threads or when this is a call or a return: " + element;
        this.mElement = element;
        this.mStep = step;
        this.mStepInfo = info;
        this.mPrecedingProcedure = precedingProcedure;
        this.mSucceedingProcedure = succeedingProcedure;
        this.mToStringFunc = toStringProvider;
        this.mRelevanceInformation = relInfo;
        this.mThreadId = threadId;
        this.mForkedThreadId = forkedThreadId;
    }

    public TE getTraceElement() {
        return this.mElement;
    }

    public TE getStep() {
        return this.mStep;
    }

    public boolean hasStepInfo(StepInfo info) {
        return this.mStepInfo.contains((Object)info);
    }

    public boolean hasAnyStepInfo(StepInfo ... infos) {
        return AtomicTraceElement.hasAnyStepInfo(this.getStepInfo(), infos);
    }

    public static boolean hasAnyStepInfo(EnumSet<StepInfo> set, StepInfo ... infos) {
        if (infos == null || infos.length == 0) {
            return true;
        }
        StepInfo[] stepInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            StepInfo info = stepInfoArray[n2];
            if (set.contains((Object)info)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public EnumSet<StepInfo> getStepInfo() {
        return EnumSet.copyOf(this.mStepInfo);
    }

    public boolean hasThreadId() {
        return this.mThreadId != null;
    }

    public int getThreadId() {
        return this.mThreadId;
    }

    public boolean isMainThread() {
        return this.mThreadId == -1;
    }

    public int getForkedThreadId() {
        return this.mForkedThreadId;
    }

    public IRelevanceInformation getRelevanceInformation() {
        return this.mRelevanceInformation;
    }

    public String getPrecedingProcedure() {
        return this.mPrecedingProcedure;
    }

    public String getSucceedingProcedure() {
        return this.mSucceedingProcedure;
    }

    public String toString() {
        IRelevanceInformation relInfo;
        StringBuilder sb = new StringBuilder();
        if (this.mStepInfo.contains((Object)StepInfo.NONE)) {
            sb.append(this.mToStringFunc.toString(this.getTraceElement()));
        } else {
            sb.append(this.getStepInfo());
            sb.append(" ");
            sb.append(this.mToStringFunc.toString(this.getStep()));
        }
        if (this.hasThreadId()) {
            sb.append(" ");
            sb.append(this.getThreadId());
        }
        if ((relInfo = this.getRelevanceInformation()) != null) {
            sb.append(" ");
            sb.append(relInfo);
        }
        return sb.toString();
    }

    /* synthetic */ AtomicTraceElement(Object object, Object object2, EnumSet enumSet, IToString iToString, IRelevanceInformation iRelevanceInformation, String string, String string2, Integer n, Integer n2, AtomicTraceElement atomicTraceElement) {
        this(object, object2, enumSet, iToString, iRelevanceInformation, string, string2, n, n2);
    }

    public static final class AtomicTraceElementBuilder<TE> {
        private TE mElement;
        private TE mStep;
        private IToString<TE> mToStringFunc;
        private IRelevanceInformation mRelevanceInformation;
        private String mPrecedingProcedure;
        private String mSucceedingProcedure;
        private Integer mThreadId;
        private EnumSet<StepInfo> mStepInfo;
        private Integer mForkedThreadId;

        public AtomicTraceElementBuilder() {
            this.mToStringFunc = a -> a.toString();
            this.mStepInfo = EnumSet.of(StepInfo.NONE);
        }

        private AtomicTraceElementBuilder(AtomicTraceElement<TE> old) {
            this.mToStringFunc = ((AtomicTraceElement)old).mToStringFunc;
            this.mStepInfo = EnumSet.copyOf(((AtomicTraceElement)old).mStepInfo);
            this.mPrecedingProcedure = ((AtomicTraceElement)old).mPrecedingProcedure;
            this.mSucceedingProcedure = ((AtomicTraceElement)old).mSucceedingProcedure;
            this.mStep = ((AtomicTraceElement)old).mStep;
            this.mElement = ((AtomicTraceElement)old).mElement;
            this.mThreadId = ((AtomicTraceElement)old).mThreadId;
            this.mRelevanceInformation = ((AtomicTraceElement)old).mRelevanceInformation;
            this.mForkedThreadId = ((AtomicTraceElement)old).mForkedThreadId;
        }

        public static <TE> AtomicTraceElementBuilder<TE> from(AtomicTraceElement<TE> old) {
            return new AtomicTraceElementBuilder<TE>(old);
        }

        public static <TE> AtomicTraceElementBuilder<TE> fromReplaceElementAndStep(AtomicTraceElement<?> old, TE elem) {
            AtomicTraceElementBuilder<TE> rtr = new AtomicTraceElementBuilder<TE>().setStepAndElement(elem).setStepInfo(old.getStepInfo()).setRelevanceInformation(old.getRelevanceInformation()).setProcedures(old.getPrecedingProcedure(), old.getSucceedingProcedure());
            if (old.hasThreadId()) {
                rtr.setThreadId(old.getThreadId());
            }
            if (old.hasStepInfo(StepInfo.FORK)) {
                rtr.setForkedThreadId(old.getForkedThreadId());
            }
            return rtr;
        }

        public static <TE> AtomicTraceElementBuilder<TE> fromReplaceElementAndStep(AtomicTraceElement<?> old, TE elem, TE step) {
            AtomicTraceElementBuilder<TE> rtr = new AtomicTraceElementBuilder<TE>().setElement(elem).setStep(step).setStepInfo(old.getStepInfo()).setRelevanceInformation(old.getRelevanceInformation()).setProcedures(old.getPrecedingProcedure(), old.getSucceedingProcedure());
            if (old.hasThreadId()) {
                rtr.setThreadId(old.getThreadId());
            }
            if (old.hasStepInfo(StepInfo.FORK)) {
                rtr.setForkedThreadId(old.getForkedThreadId());
            }
            return rtr;
        }

        public AtomicTraceElement<TE> build() {
            return new AtomicTraceElement(this.mElement, this.mStep, this.mStepInfo, this.mToStringFunc, this.mRelevanceInformation, this.mPrecedingProcedure, this.mSucceedingProcedure, this.mThreadId, this.mForkedThreadId, null);
        }

        public AtomicTraceElementBuilder<TE> setElement(TE element) {
            this.mElement = element;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setStep(TE step) {
            this.mStep = step;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setStepAndElement(TE step) {
            this.mStep = step;
            this.mElement = step;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setToStringFunc(IToString<TE> toStringFunc) {
            this.mToStringFunc = Objects.requireNonNull(toStringFunc);
            return this;
        }

        public AtomicTraceElementBuilder<TE> addStepInfo(StepInfo ... stepInfo) {
            if (stepInfo == null || stepInfo.length == 0) {
                return this;
            }
            if (stepInfo.length == 1 && stepInfo[0] == StepInfo.NONE) {
                this.mStepInfo = EnumSet.of(StepInfo.NONE);
                return this;
            }
            if (this.mStepInfo.contains((Object)StepInfo.NONE)) {
                this.mStepInfo.clear();
            }
            StepInfo[] stepInfoArray = stepInfo;
            int n = stepInfo.length;
            int n2 = 0;
            while (n2 < n) {
                StepInfo info = stepInfoArray[n2];
                if (info == StepInfo.NONE) {
                    throw new IllegalArgumentException("Cannot combine NONE with any other value");
                }
                this.mStepInfo.add(info);
                ++n2;
            }
            return this;
        }

        public AtomicTraceElementBuilder<TE> setStepInfo(StepInfo ... stepInfo) {
            if (stepInfo == null || stepInfo.length == 0) {
                this.mStepInfo = EnumSet.of(StepInfo.NONE);
                return this;
            }
            this.mStepInfo.clear();
            StepInfo[] stepInfoArray = stepInfo;
            int n = stepInfo.length;
            int n2 = 0;
            while (n2 < n) {
                StepInfo info = stepInfoArray[n2];
                this.mStepInfo.add(info);
                ++n2;
            }
            if (this.mStepInfo.size() > 1 && this.mStepInfo.contains((Object)StepInfo.NONE)) {
                throw new IllegalArgumentException("Cannot combine NONE with any other value");
            }
            return this;
        }

        public AtomicTraceElementBuilder<TE> setStepInfo(EnumSet<StepInfo> stepInfo) {
            return this.setStepInfo(stepInfo.toArray(new StepInfo[stepInfo.size()]));
        }

        public AtomicTraceElementBuilder<TE> setRelevanceInformation(IRelevanceInformation relevanceInformation) {
            this.mRelevanceInformation = relevanceInformation;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setProcedures(String precedingProcedure, String succeedingProcedure) {
            this.mPrecedingProcedure = precedingProcedure;
            this.mSucceedingProcedure = succeedingProcedure;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setThreadId(int threadId) {
            this.mThreadId = threadId;
            return this;
        }

        public Integer getForkedThreadId() {
            return this.mForkedThreadId;
        }

        public AtomicTraceElementBuilder<TE> setForkedThreadId(int threadId) {
            this.mForkedThreadId = threadId;
            return this;
        }
    }

    public static enum StepInfo {
        NONE("NONE"),
        CONDITION_EVAL_TRUE("COND TRUE"),
        CONDITION_EVAL_FALSE("COND FALSE"),
        PROC_CALL("CALL"),
        PROC_RETURN("RET"),
        ARG_EVAL("ARG"),
        EXPR_EVAL("EXPR"),
        FUNC_CALL("FCALL"),
        FORK("FORK"),
        JOIN("JOIN");

        private final String mText;

        private StepInfo(String text) {
            this.mText = text;
        }

        public String toString() {
            return this.mText;
        }
    }
}

