/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.translation;

import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface IProgramExecution<TE, E>
extends Iterable<AtomicTraceElement<TE>> {
    public int getLength();

    public AtomicTraceElement<TE> getTraceElement(int var1);

    public ProgramState<E> getProgramState(int var1);

    public ProgramState<E> getInitialProgramState();

    public Class<E> getExpressionClass();

    public Class<? extends TE> getTraceElementClass();

    public String toString();

    public boolean isConcurrent();

    default public List<ProgramState<E>> getProgramStates() {
        ArrayList<ProgramState<ProgramState<E>>> rtr = new ArrayList<ProgramState<ProgramState<E>>>(this.getLength() + 1);
        rtr.add(this.getInitialProgramState());
        int i = 0;
        while (i < this.getLength()) {
            rtr.add(this.getProgramState(i));
            ++i;
        }
        return rtr;
    }

    @Override
    default public Spliterator<AtomicTraceElement<TE>> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.getLength(), 1104);
    }

    default public Stream<AtomicTraceElement<TE>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    default public Iterator<AtomicTraceElement<TE>> iterator() {
        return new Iterator<AtomicTraceElement<TE>>(){
            private final int max;
            private int current;
            {
                this.max = IProgramExecution.this.getLength();
                this.current = 0;
            }

            @Override
            public boolean hasNext() {
                return this.current < this.max;
            }

            @Override
            public AtomicTraceElement<TE> next() {
                return IProgramExecution.this.getTraceElement(this.current++);
            }
        };
    }

    public IBacktranslationValueProvider<TE, E> getBacktranslationValueProvider();

    public static <TE, E> IProgramExecution<TE, E> emptyExecution(final Class<E> exprClass, final Class<? extends TE> teClass) {
        return new IProgramExecution<TE, E>(){

            @Override
            public int getLength() {
                return 0;
            }

            @Override
            public AtomicTraceElement<TE> getTraceElement(int index) {
                return null;
            }

            @Override
            public ProgramState<E> getProgramState(int index) {
                return null;
            }

            @Override
            public ProgramState<E> getInitialProgramState() {
                return null;
            }

            @Override
            public Class<E> getExpressionClass() {
                return exprClass;
            }

            @Override
            public Class<? extends TE> getTraceElementClass() {
                return teClass;
            }

            @Override
            public IBacktranslationValueProvider<TE, E> getBacktranslationValueProvider() {
                return null;
            }

            @Override
            public boolean isConcurrent() {
                return false;
            }
        };
    }

    public static class ProgramState<E> {
        private final Class<E> mClassOfExpression;
        private final Map<E, Collection<E>> mVariable2Values;

        public ProgramState(Map<E, Collection<E>> variable2Values, Class<E> classOfExpression) {
            this.mClassOfExpression = classOfExpression;
            this.mVariable2Values = variable2Values;
        }

        public Set<E> getVariables() {
            return this.mVariable2Values.keySet();
        }

        public Collection<E> getValues(E variable) {
            return this.mVariable2Values.get(variable);
        }

        public Class<E> getClassOfExpression() {
            return this.mClassOfExpression;
        }

        public String toString(Function<E, String> expressionToString) {
            List<Map.Entry<E, Collection<E>>> toSort = ProgramState.constructSortedListOfEntries(this.mVariable2Values);
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<E, Collection<E>> entry : toSort) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(expressionToString.apply(entry.getKey()));
                if (entry.getValue().size() == 1) {
                    sb.append("=");
                    E theElement = entry.getValue().iterator().next();
                    sb.append(expressionToString.apply(theElement));
                    continue;
                }
                sb.append(" in");
                sb.append(entry.getValue().stream().map(expressionToString).collect(Collectors.joining(",")));
            }
            return sb.toString();
        }

        private static <E> List<Map.Entry<E, Collection<E>>> constructSortedListOfEntries(Map<E, Collection<E>> variable2values) {
            ArrayList<Map.Entry<E, Collection<E>>> toSort = new ArrayList<Map.Entry<E, Collection<E>>>(variable2values.entrySet());
            Collections.sort(toSort, new Comparator<Map.Entry<E, Collection<E>>>(){

                @Override
                public int compare(Map.Entry<E, Collection<E>> arg0, Map.Entry<E, Collection<E>> arg1) {
                    return arg0.getKey().toString().compareToIgnoreCase(arg1.getKey().toString());
                }
            });
            return toSort;
        }

        public String toString() {
            return this.toString(String::valueOf);
        }
    }
}

