/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.exceptions;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import java.util.EnumSet;
import java.util.Iterator;

public class TaskCanceledException
extends ToolchainCanceledException {
    private static final long serialVersionUID = 7665045856874634524L;
    private final EnumSet<UserDefinedLimit> mLimits;

    public TaskCanceledException(UserDefinedLimit limit, Class<?> thrower, String runningTaskDescription) {
        this(EnumSet.of(limit), thrower, runningTaskDescription);
    }

    public TaskCanceledException(EnumSet<UserDefinedLimit> limits, Class<?> thrower, String runningTaskDescription) {
        super(TaskCanceledException.humanReadableLimits(limits), thrower, runningTaskDescription);
        this.mLimits = limits;
    }

    public EnumSet<UserDefinedLimit> getLimits() {
        return this.mLimits;
    }

    private static String humanReadableLimits(EnumSet<UserDefinedLimit> limits) {
        Iterator iter = limits.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append("The user-defined ");
        if (limits.size() == 1) {
            sb.append("limit ");
            sb.append(((UserDefinedLimit)((Object)iter.next())).toString());
            sb.append(" has been reached");
        } else {
            sb.append("limits ");
            sb.append(((UserDefinedLimit)((Object)iter.next())).toString());
            while (iter.hasNext()) {
                sb.append(" and ");
                sb.append(((UserDefinedLimit)((Object)iter.next())).toString());
            }
            sb.append(" have been reached");
        }
        return sb.toString();
    }

    public static enum UserDefinedLimit {
        TRACE_HISTOGRAM,
        TIME_PER_ERROR_LOCATION,
        PATH_PROGRAM_ATTEMPTS,
        ITERATIONS;

    }
}

