/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.exceptions;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackReceiver;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ToolchainCanceledException
extends RuntimeException
implements IRunningTaskStackProvider,
IRunningTaskStackReceiver {
    private static final long serialVersionUID = 7090759880566576629L;
    private static final String MESSAGE = "Timeout or Toolchain cancelled by user";
    private final transient List<RunningTaskInfo> mRunningTaskInfos = new ArrayList<RunningTaskInfo>();

    public ToolchainCanceledException(Class<?> thrower) {
        this(MESSAGE, new RunningTaskInfo(thrower, null));
    }

    public ToolchainCanceledException(Class<?> thrower, String runningTaskDescription) {
        this(MESSAGE, new RunningTaskInfo(thrower, runningTaskDescription));
    }

    public ToolchainCanceledException(RunningTaskInfo runningTaskInfo) {
        this(MESSAGE, runningTaskInfo);
    }

    public ToolchainCanceledException(IRunningTaskStackProvider rtsp, RunningTaskInfo runningTaskInfo) {
        this(MESSAGE, rtsp, runningTaskInfo);
    }

    public ToolchainCanceledException(String message, Class<?> thrower, String runningTaskDescription) {
        this(message, new RunningTaskInfo(thrower, runningTaskDescription));
    }

    public ToolchainCanceledException(String message, RunningTaskInfo runningTaskInfo) {
        this(message, null, runningTaskInfo);
    }

    protected ToolchainCanceledException(String message, IRunningTaskStackProvider rtsp, RunningTaskInfo runningTaskInfo) {
        super(Objects.requireNonNull(message));
        if (rtsp != null) {
            this.mRunningTaskInfos.addAll(rtsp.getRunningTaskStack());
        }
        this.mRunningTaskInfos.add(Objects.requireNonNull(runningTaskInfo));
    }

    @Override
    public void addRunningTaskInfo(RunningTaskInfo runningTaskInfo) {
        this.mRunningTaskInfos.add(runningTaskInfo);
    }

    @Override
    public List<RunningTaskInfo> getRunningTaskStack() {
        return this.mRunningTaskInfos;
    }
}

