/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BasePayloadContainer;
import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IDirectedGraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDirectedGraph<T extends IDirectedGraph<T, VisualizationNode>>
extends BasePayloadContainer
implements IDirectedGraph<T, VisualizationNode> {
    private static final long serialVersionUID = 1L;
    protected List<T> mOutgoingNodes = new ArrayList<T>();
    protected List<T> mIncomingNodes = new ArrayList<T>();

    protected BaseDirectedGraph() {
        this(null, null);
    }

    protected BaseDirectedGraph(IPayload payload) {
        this(null, payload);
    }

    protected BaseDirectedGraph(T parent) {
        this(parent, null);
    }

    protected BaseDirectedGraph(T parent, IPayload payload) {
        super(payload);
        if (parent != null) {
            this.mIncomingNodes.add(parent);
            parent.getOutgoingNodes().add(this);
        }
    }

    public List<T> getIncomingNodes() {
        return this.mIncomingNodes;
    }

    public List<T> getOutgoingNodes() {
        return this.mOutgoingNodes;
    }

    public List<IWalkable> getSuccessors() {
        return this.getOutgoingNodes();
    }

    public VisualizationNode getVisualizationGraph() {
        return new VisualizationNode(this);
    }
}

