/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BaseMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.lib.models.BasePayloadContainer;
import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseExplicitEdgesMultigraph<V extends IExplicitEdgesMultigraph<V, E, VL, EL, VisualizationNode>, E extends IMultigraphEdge<V, E, VL, EL, VisualizationNode>, VL, EL>
extends BasePayloadContainer
implements IExplicitEdgesMultigraph<V, E, VL, EL, VisualizationNode> {
    private static final long serialVersionUID = 1L;
    protected List<E> mOutgoingEdges = new ArrayList();
    protected List<E> mIncomingEdges = new ArrayList();

    protected BaseExplicitEdgesMultigraph() {
        this(null, null, null);
    }

    protected BaseExplicitEdgesMultigraph(IPayload payload) {
        this(null, null, payload);
    }

    protected BaseExplicitEdgesMultigraph(V predecessor) {
        this(predecessor, null, null);
    }

    protected BaseExplicitEdgesMultigraph(V predecessor, IPayload edgePayload) {
        this(predecessor, edgePayload, null);
    }

    protected BaseExplicitEdgesMultigraph(V predecessor, IPayload edgePayload, IPayload payload) {
        super(payload);
        if (predecessor != null) {
            BaseMultigraphEdge e = new BaseMultigraphEdge<V, E, VL, EL>((IExplicitEdgesMultigraph)predecessor, this, payload){
                private static final long serialVersionUID = 1L;

                public EL getLabel() {
                    return null;
                }
            };
            predecessor.getOutgoingEdges().add(e);
            this.mIncomingEdges.add(e);
        }
    }

    public List<E> getIncomingEdges() {
        return this.mIncomingEdges;
    }

    public List<E> getOutgoingEdges() {
        return this.mOutgoingEdges;
    }

    public List<V> getOutgoingNodes() {
        ArrayList<IExplicitEdgesMultigraph> rtr = new ArrayList<IExplicitEdgesMultigraph>();
        for (IMultigraphEdge e : this.getOutgoingEdges()) {
            IExplicitEdgesMultigraph target = e.getTarget();
            if (target == null) continue;
            rtr.add(target);
        }
        return rtr;
    }

    public List<V> getIncomingNodes() {
        ArrayList<IExplicitEdgesMultigraph> rtr = new ArrayList<IExplicitEdgesMultigraph>();
        for (IMultigraphEdge e : this.getIncomingEdges()) {
            IExplicitEdgesMultigraph source = e.getSource();
            if (source == null) continue;
            rtr.add(source);
        }
        return rtr;
    }

    public VisualizationNode getVisualizationGraph() {
        return new VisualizationNode(this);
    }

    public List<IWalkable> getSuccessors() {
        return this.getOutgoingEdges();
    }
}

