/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BasePayloadContainer;
import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILabeledEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseLabeledEdgesMultigraph<T extends BaseLabeledEdgesMultigraph<T, L>, L>
extends BasePayloadContainer
implements ILabeledEdgesMultigraph<T, L, VisualizationNode> {
    private static final long serialVersionUID = 1L;
    protected List<T> mOutgoingNodes;
    protected List<T> mIncomingNodes;
    protected List<L> mOutgoingEdgeLabels = new ArrayList<L>();

    protected BaseLabeledEdgesMultigraph() {
        this(null, null, null);
    }

    protected BaseLabeledEdgesMultigraph(IPayload payload) {
        this(null, null, payload);
    }

    protected BaseLabeledEdgesMultigraph(T parent) {
        this(parent, null, null);
    }

    protected BaseLabeledEdgesMultigraph(T parent, L incomingEdgeLabel) {
        this(parent, incomingEdgeLabel, null);
    }

    protected BaseLabeledEdgesMultigraph(T predecessor, L incomingEdgeLabel, IPayload payload) {
        super(payload);
        this.mOutgoingNodes = new ArrayList<T>();
        this.mIncomingNodes = new ArrayList<T>();
        if (predecessor != null) {
            ((BaseLabeledEdgesMultigraph)predecessor).mOutgoingEdgeLabels.add(incomingEdgeLabel);
            ((BaseLabeledEdgesMultigraph)predecessor).mOutgoingNodes.add(this);
            this.mIncomingNodes.add(predecessor);
        }
    }

    public List<T> getIncomingNodes() {
        return this.mIncomingNodes;
    }

    public List<T> getOutgoingNodes() {
        return this.mOutgoingNodes;
    }

    public L getOutgoingEdgeLabel(T node) {
        return this.mOutgoingEdgeLabels.get(this.mOutgoingNodes.indexOf(node));
    }

    public L getIncomingEdgeLabel(T node) {
        if (node != null) {
            return ((BaseLabeledEdgesMultigraph)node).mOutgoingEdgeLabels.get(((BaseLabeledEdgesMultigraph)node).mOutgoingNodes.indexOf(this));
        }
        return null;
    }

    public VisualizationNode getVisualizationGraph() {
        return new VisualizationNode(this);
    }

    public List<IWalkable> getSuccessors() {
        return this.getOutgoingNodes();
    }

    public List<L> getOutgoingEdgeLabels() {
        return this.mOutgoingEdgeLabels;
    }
}

