/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BaseDirectedGraph;
import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableDirectedGraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import java.util.Collection;

public abstract class ModifiableDirectedGraph<T extends IModifiableDirectedGraph<T, VisualizationNode>>
extends BaseDirectedGraph<T>
implements IModifiableDirectedGraph<T, VisualizationNode> {
    private static final long serialVersionUID = 1L;

    protected ModifiableDirectedGraph() {
        this(null, null);
    }

    protected ModifiableDirectedGraph(IPayload payload) {
        this(null, payload);
    }

    protected ModifiableDirectedGraph(T parent) {
        this(parent, null);
    }

    protected ModifiableDirectedGraph(T parent, IPayload payload) {
        super(parent, payload);
    }

    public boolean connectIncoming(T predecessor) {
        boolean thisIncomingChanged = this.addIncoming(predecessor);
        boolean predecessorOutgoingChanged = predecessor.addOutgoing((Object)this);
        assert (thisIncomingChanged == predecessorOutgoingChanged);
        return thisIncomingChanged;
    }

    public boolean disconnectIncoming(T predecessor) {
        boolean thisIncomingChanged = this.removeIncoming(predecessor);
        boolean predecessorOutgoingChanged = predecessor.removeOutgoing((Object)this);
        assert (thisIncomingChanged == predecessorOutgoingChanged);
        return thisIncomingChanged;
    }

    public boolean connectOutgoing(T successor) {
        boolean thisOutgoingChanged = this.addOutgoing(successor);
        boolean predecessorIncomingChanged = successor.addIncoming((Object)this);
        assert (thisOutgoingChanged == predecessorIncomingChanged);
        return thisOutgoingChanged;
    }

    public boolean disconnectOutgoing(T successor) {
        boolean thisOutgoingChanged = this.removeOutgoing(successor);
        boolean predecessorIncomingChanged = successor.removeIncoming((Object)this);
        assert (thisOutgoingChanged == predecessorIncomingChanged);
        return thisOutgoingChanged;
    }

    public boolean addOutgoing(T outgoing) {
        if (outgoing == this) assert (false);
        if (outgoing != null) {
            return this.mOutgoingNodes.add(outgoing);
        }
        return false;
    }

    public boolean addOutgoing(int index, T outgoing) {
        int i = this.mOutgoingNodes.size();
        this.mOutgoingNodes.add(index, outgoing);
        return i != this.mOutgoingNodes.size();
    }

    public boolean addAllOutgoing(Collection<? extends T> c) {
        boolean rtr = false;
        for (IModifiableDirectedGraph outgoing : c) {
            rtr |= this.addOutgoing((T)outgoing);
        }
        return rtr;
    }

    public boolean addAllOutgoing(int index, Collection<? extends T> c) {
        return this.mOutgoingNodes.addAll(index, c);
    }

    public void clearOutgoing() {
        this.mOutgoingNodes.clear();
    }

    public T removeOutgoing(int index) {
        return (T)((IModifiableDirectedGraph)this.mOutgoingNodes.remove(index));
    }

    public boolean removeOutgoing(T o) {
        return this.mOutgoingNodes.remove(o);
    }

    public boolean removeAllOutgoing(Collection<? extends T> c) {
        boolean rtr = false;
        for (IModifiableDirectedGraph o : c) {
            rtr |= this.removeOutgoing((T)o);
        }
        return rtr;
    }

    public boolean addIncoming(T incoming) {
        if (incoming == this) assert (false);
        if (incoming != null) {
            return this.mIncomingNodes.add(incoming);
        }
        return false;
    }

    public boolean addIncoming(int index, T incoming) {
        int i = this.mIncomingNodes.size();
        this.mIncomingNodes.add(index, incoming);
        return i != this.mIncomingNodes.size();
    }

    public boolean addAllIncoming(Collection<? extends T> c) {
        boolean rtr = false;
        for (IModifiableDirectedGraph e : c) {
            rtr |= this.addIncoming((T)e);
        }
        return rtr;
    }

    public boolean addAllIncoming(int index, Collection<? extends T> c) {
        return this.mIncomingNodes.addAll(index, c);
    }

    public void clearIncoming() {
        this.mIncomingNodes.clear();
    }

    public T removeIncoming(int index) {
        return (T)((IModifiableDirectedGraph)this.mIncomingNodes.remove(index));
    }

    public boolean removeIncoming(T o) {
        return this.mIncomingNodes.remove(o);
    }

    public boolean removeAllIncoming(Collection<? extends T> c) {
        boolean rtr = false;
        for (IModifiableDirectedGraph o : c) {
            rtr |= this.removeIncoming((T)o);
        }
        return rtr;
    }
}

