/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BaseExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import java.util.Collection;

public abstract class ModifiableExplicitEdgesMultigraph<V extends IModifiableExplicitEdgesMultigraph<V, E, VL, EL, VisualizationNode>, E extends IModifiableMultigraphEdge<V, E, VL, EL, VisualizationNode>, VL, EL>
extends BaseExplicitEdgesMultigraph<V, E, VL, EL>
implements IModifiableExplicitEdgesMultigraph<V, E, VL, EL, VisualizationNode> {
    private static final long serialVersionUID = 1L;

    protected ModifiableExplicitEdgesMultigraph() {
        this(null, null, null);
    }

    protected ModifiableExplicitEdgesMultigraph(IPayload payload) {
        this(null, null, payload);
    }

    protected ModifiableExplicitEdgesMultigraph(V predecessor) {
        this(predecessor, null, null);
    }

    protected ModifiableExplicitEdgesMultigraph(V predecessor, IPayload edgePayload) {
        this(predecessor, edgePayload, null);
    }

    protected ModifiableExplicitEdgesMultigraph(V predecessor, IPayload edgePayload, IPayload payload) {
        super(predecessor, edgePayload, payload);
    }

    public boolean addOutgoing(E outgoing) {
        if (outgoing != null) {
            assert (outgoing.getSource() == this);
            return this.mOutgoingEdges.add(outgoing);
        }
        return false;
    }

    public boolean addOutgoing(int index, E outgoing) {
        int i = this.mOutgoingEdges.size();
        this.mOutgoingEdges.add(index, outgoing);
        return i != this.mOutgoingEdges.size();
    }

    public boolean addAllOutgoing(Collection<? extends E> c) {
        boolean rtr = false;
        for (IModifiableMultigraphEdge outgoing : c) {
            rtr |= this.addOutgoing((E)outgoing);
        }
        return rtr;
    }

    public boolean addAllOutgoing(int index, Collection<? extends E> c) {
        return this.mOutgoingEdges.addAll(index, c);
    }

    public void clearOutgoing() {
        this.mOutgoingEdges.clear();
    }

    public E removeOutgoing(int index) {
        return (E)((IModifiableMultigraphEdge)this.mOutgoingEdges.remove(index));
    }

    public boolean removeOutgoing(E o) {
        return this.mOutgoingEdges.remove(o);
    }

    public boolean removeAllOutgoing(Collection<? extends E> c) {
        boolean rtr = false;
        for (IModifiableMultigraphEdge o : c) {
            rtr |= this.removeOutgoing((E)o);
        }
        return rtr;
    }

    public boolean addIncoming(E incoming) {
        if (incoming != null) {
            assert (incoming.getTarget() == this);
            return this.mIncomingEdges.add(incoming);
        }
        return false;
    }

    public boolean addIncoming(int index, E incoming) {
        int i = this.mIncomingEdges.size();
        this.mIncomingEdges.add(index, incoming);
        return i != this.mIncomingEdges.size();
    }

    public boolean addAllIncoming(Collection<? extends E> c) {
        boolean rtr = false;
        for (IModifiableMultigraphEdge e : c) {
            rtr |= this.addIncoming((E)e);
        }
        return rtr;
    }

    public boolean addAllIncoming(int index, Collection<? extends E> c) {
        return this.mIncomingEdges.addAll(index, c);
    }

    public void clearIncoming() {
        this.mIncomingEdges.clear();
    }

    public E removeIncoming(int index) {
        return (E)((IModifiableMultigraphEdge)this.mIncomingEdges.remove(index));
    }

    public boolean removeIncoming(E o) {
        return this.mIncomingEdges.remove(o);
    }

    public boolean removeAllIncoming(Collection<? extends E> c) {
        boolean rtr = false;
        for (IModifiableMultigraphEdge o : c) {
            rtr |= this.removeIncoming((E)o);
        }
        return rtr;
    }
}

