/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models;

import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IDirectedGraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILabeledEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.ISimpleAST;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class VisualizationNode
implements IExplicitEdgesMultigraph<VisualizationNode, VisualizationEdge, VisualizationNode, VisualizationEdge, VisualizationNode> {
    private static final long serialVersionUID = 1L;
    private final VisualizationWrapperNode mBacking;
    private List<VisualizationNode> mOutgoing;

    public VisualizationNode(IExplicitEdgesMultigraph<?, ?, ?, ?, VisualizationNode> node) {
        this.mBacking = new VisualizationWrapperNode(this, (IElement)node, (IExplicitEdgesMultigraph)node){
            private final /* synthetic */ IExplicitEdgesMultigraph val$node;
            {
                this.val$node = iExplicitEdgesMultigraph;
                super($anonymous0);
            }

            @Override
            protected void createIncoming() {
                for (IMultigraphEdge e : this.val$node.getIncomingEdges()) {
                    if (e.getSource() == null) continue;
                    VisualizationEdge ve = e.hasPayload() ? new VisualizationEdge((VisualizationNode)e.getSource().getVisualizationGraph(), this, e.getPayload(), e) : new VisualizationEdge((VisualizationNode)e.getSource().getVisualizationGraph(), this, e);
                    this.mIncoming.add(ve);
                }
            }

            @Override
            protected void createOutgoing() {
                for (IMultigraphEdge e : this.val$node.getOutgoingEdges()) {
                    if (e.getTarget() == null) continue;
                    VisualizationEdge ve = e.hasPayload() ? new VisualizationEdge(this, (VisualizationNode)e.getTarget().getVisualizationGraph(), e.getPayload(), e) : new VisualizationEdge(this, (VisualizationNode)e.getTarget().getVisualizationGraph(), e);
                    this.mOutgoing.add(ve);
                }
            }

            @Override
            protected List<IWalkable> getSuccessors() {
                return this.getOutgoingEdges();
            }
        };
    }

    private static IPayload extractPayload(Object label) {
        IElement ele;
        IPayload pay = null;
        if (label instanceof IPayload) {
            pay = (IPayload)label;
        } else if (label instanceof IElement && (ele = (IElement)label).hasPayload()) {
            pay = ele.getPayload();
        }
        return pay;
    }

    public <T extends ILabeledEdgesMultigraph<T, L, VisualizationNode>, L> VisualizationNode(ILabeledEdgesMultigraph<T, L, VisualizationNode> node) {
        this.mBacking = new VisualizationWrapperNode(this, (IElement)node, (ILabeledEdgesMultigraph)node){
            private final /* synthetic */ ILabeledEdgesMultigraph val$node;
            {
                this.val$node = iLabeledEdgesMultigraph;
                super($anonymous0);
            }

            @Override
            protected void createIncoming() {
                for (ILabeledEdgesMultigraph pred : this.val$node.getIncomingNodes()) {
                    IPayload pay = VisualizationNode.extractPayload(this.val$node.getIncomingEdgeLabel(pred));
                    VisualizationEdge ve = pay != null ? new VisualizationEdge((VisualizationNode)pred.getVisualizationGraph(), this, pay, null) : new VisualizationEdge((VisualizationNode)pred.getVisualizationGraph(), this, (Object)null);
                    this.mIncoming.add(ve);
                }
            }

            @Override
            protected void createOutgoing() {
                for (ILabeledEdgesMultigraph succ : this.val$node.getOutgoingNodes()) {
                    IPayload pay = VisualizationNode.extractPayload(this.val$node.getOutgoingEdgeLabel(succ));
                    VisualizationEdge ve = pay != null ? new VisualizationEdge(this, (VisualizationNode)succ.getVisualizationGraph(), pay, null) : new VisualizationEdge(this, (VisualizationNode)succ.getVisualizationGraph(), (Object)null);
                    this.mOutgoing.add(ve);
                }
            }

            @Override
            protected List<IWalkable> getSuccessors() {
                ArrayList<IWalkable> rtr = new ArrayList<IWalkable>();
                Iterator iterator = this.val$node.getOutgoingNodes().iterator();
                while (iterator.hasNext()) {
                    ILabeledEdgesMultigraph succ;
                    ILabeledEdgesMultigraph child = succ = (ILabeledEdgesMultigraph)iterator.next();
                    rtr.add(new IWalkableImplementation(this, this.val$node, child));
                }
                return rtr;
            }
        };
    }

    public VisualizationNode(ISimpleAST<?, VisualizationNode> node) {
        this.mBacking = new VisualizationWrapperNode(this, (IElement)node, (ISimpleAST)node){
            private final /* synthetic */ ISimpleAST val$node;
            {
                this.val$node = iSimpleAST;
                super($anonymous0);
            }

            @Override
            protected List<IWalkable> getSuccessors() {
                return this.getOutgoingEdges();
            }

            @Override
            protected void createOutgoing() {
                this.mIncoming = new ArrayList();
                for (ISimpleAST succ : this.val$node.getOutgoingNodes()) {
                    if (succ == null) continue;
                    VisualizationEdge ve = succ.hasPayload() ? new VisualizationEdge(this, (VisualizationNode)succ.getVisualizationGraph(), succ.getPayload(), succ) : new VisualizationEdge(this, (VisualizationNode)succ.getVisualizationGraph(), succ);
                    this.mOutgoing.add(ve);
                }
            }

            @Override
            protected void createIncoming() {
            }
        };
    }

    public VisualizationNode(IDirectedGraph<?, VisualizationNode> node) {
        this(node, new HashMap<IElement, VisualizationWrapperNode>());
    }

    private VisualizationNode(IDirectedGraph<?, VisualizationNode> node, HashMap<IElement, VisualizationWrapperNode> backingDirectory) {
        if (backingDirectory.containsKey(node)) {
            this.mBacking = backingDirectory.get(node);
        } else {
            this.mBacking = new VisualizationWrapperNode(this, (IElement)node, (IDirectedGraph)node, backingDirectory){
                private final /* synthetic */ IDirectedGraph val$node;
                private final /* synthetic */ HashMap val$backingDirectory;
                {
                    this.val$node = iDirectedGraph;
                    this.val$backingDirectory = hashMap;
                    super($anonymous0);
                }

                @Override
                protected List<IWalkable> getSuccessors() {
                    return this.getOutgoingEdges();
                }

                @Override
                protected void createOutgoing() {
                    for (IDirectedGraph succ : this.val$node.getOutgoingNodes()) {
                        this.mOutgoing.add(new VisualizationEdge(this, new VisualizationNode(succ, this.val$backingDirectory), (Object)null));
                    }
                }

                @Override
                protected void createIncoming() {
                    for (IDirectedGraph pred : this.val$node.getOutgoingNodes()) {
                        this.mIncoming.add(new VisualizationEdge(new VisualizationNode(pred, this.val$backingDirectory), this, (Object)null));
                    }
                }
            };
            backingDirectory.put((IElement)node, this.mBacking);
        }
    }

    public List<VisualizationNode> getOutgoingNodes() {
        if (this.mOutgoing == null) {
            this.mOutgoing = new ArrayList<VisualizationNode>();
            for (VisualizationEdge e : this.getOutgoingEdges()) {
                this.mOutgoing.add((VisualizationNode)e.getTarget());
            }
        }
        return this.mOutgoing;
    }

    public Object getBacking() {
        if (this.mBacking == null) {
            return null;
        }
        return this.mBacking.mBackingNode;
    }

    public IPayload getPayload() {
        return this.mBacking.getPayload();
    }

    public boolean hasPayload() {
        return this.mBacking.hasPayload();
    }

    public VisualizationNode getVisualizationGraph() {
        return this.mBacking.getVisualizationGraph();
    }

    public List<IWalkable> getSuccessors() {
        return this.mBacking.getSuccessors();
    }

    public List<VisualizationEdge> getIncomingEdges() {
        return this.mBacking.getIncomingEdges();
    }

    public List<VisualizationEdge> getOutgoingEdges() {
        return this.mBacking.getOutgoingEdges();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VisualizationNode) {
            return this.mBacking.equals(((VisualizationNode)obj).mBacking);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.mBacking.hashCode();
    }

    public String toString() {
        String s = this.mBacking.toString();
        if (s.length() > 30) {
            s = s.substring(0, 30);
        }
        return s;
    }

    public VisualizationNode getLabel() {
        return this;
    }

    private static final class IWalkableImplementation<T extends ILabeledEdgesMultigraph<T, L, VisualizationNode>, L>
    implements IWalkable {
        private final T mNode;
        private final T mChild;
        private static final long serialVersionUID = 1L;
        final /* synthetic */ VisualizationNode this$0;

        private IWalkableImplementation(T node, T child) {
            this.this$0 = var1_1;
            this.mNode = node;
            this.mChild = child;
        }

        public boolean hasPayload() {
            return VisualizationNode.extractPayload(this.mNode.getOutgoingEdgeLabel(this.mChild)) != null;
        }

        public IPayload getPayload() {
            return VisualizationNode.extractPayload(this.mNode.getOutgoingEdgeLabel(this.mChild));
        }

        public List<IWalkable> getSuccessors() {
            return Collections.singletonList(this.mChild);
        }
    }

    private abstract class VisualizationWrapperNode {
        private final IElement mBackingNode;
        protected List<VisualizationEdge> mOutgoing;
        protected List<VisualizationEdge> mIncoming;

        protected VisualizationWrapperNode(IElement backing) {
            this.mBackingNode = backing;
        }

        protected IPayload getPayload() {
            return this.mBackingNode.getPayload();
        }

        protected boolean hasPayload() {
            return this.mBackingNode.hasPayload();
        }

        protected VisualizationNode getVisualizationGraph() {
            return VisualizationNode.this;
        }

        protected List<VisualizationEdge> getOutgoingEdges() {
            if (this.mOutgoing == null) {
                this.mOutgoing = new ArrayList<VisualizationEdge>();
                this.createOutgoing();
            }
            return this.mOutgoing;
        }

        protected List<VisualizationEdge> getIncomingEdges() {
            if (this.mIncoming == null) {
                this.mIncoming = new ArrayList<VisualizationEdge>();
                this.createIncoming();
            }
            return this.mIncoming;
        }

        protected abstract void createIncoming();

        protected abstract void createOutgoing();

        protected abstract List<IWalkable> getSuccessors();

        public boolean equals(Object obj) {
            if (obj instanceof VisualizationWrapperNode) {
                return this.mBackingNode.equals(((VisualizationWrapperNode)obj).mBackingNode);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.mBackingNode.hashCode();
        }

        public String toString() {
            return this.mBackingNode.toString();
        }
    }
}

