/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import java.util.HashMap;
import java.util.Map;

public final class AtomicBlockInfo
extends ModernAnnotations {
    private static final long serialVersionUID = -8370873908642083605L;
    private final boolean mBeginAtomic;
    private final boolean mEndAtomic;

    private AtomicBlockInfo(boolean beginAtomic, boolean endAtomic) {
        this.mBeginAtomic = beginAtomic;
        this.mEndAtomic = endAtomic;
    }

    public IAnnotations merge(IAnnotations other) {
        if (other instanceof AtomicBlockInfo) {
            boolean isBegin = ((AtomicBlockInfo)other).mBeginAtomic || this.mBeginAtomic;
            boolean isEnd = ((AtomicBlockInfo)other).mEndAtomic || this.mEndAtomic;
            return new AtomicBlockInfo(isBegin, isEnd);
        }
        return super.merge(other);
    }

    @Override
    public Map<String, Object> getAnnotationsAsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Begin Block", this.mBeginAtomic);
        map.put("End Block", this.mEndAtomic);
        return map;
    }

    public static boolean isStartOfAtomicBlock(IElement element) {
        AtomicBlockInfo annotation = (AtomicBlockInfo)ModelUtils.getAnnotation((IElement)element, (String)AtomicBlockInfo.class.getName(), AtomicBlockInfo.class::cast);
        if (annotation != null) {
            return annotation.mBeginAtomic;
        }
        return false;
    }

    public static boolean isEndOfAtomicBlock(IElement element) {
        AtomicBlockInfo annotation = (AtomicBlockInfo)ModelUtils.getAnnotation((IElement)element, (String)AtomicBlockInfo.class.getName(), AtomicBlockInfo.class::cast);
        if (annotation != null) {
            return annotation.mEndAtomic;
        }
        return false;
    }

    public static void addBeginAnnotation(IElement element) {
        boolean isEnd = AtomicBlockInfo.isEndOfAtomicBlock(element);
        element.getPayload().getAnnotations().put(AtomicBlockInfo.class.getName(), new AtomicBlockInfo(true, isEnd));
    }

    public static void addEndAnnotation(IElement element) {
        boolean isBegin = AtomicBlockInfo.isStartOfAtomicBlock(element);
        element.getPayload().getAnnotations().put(AtomicBlockInfo.class.getName(), new AtomicBlockInfo(isBegin, true));
    }
}

