/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Check
extends ModernAnnotations {
    private static final String MSG_AND = " and ";
    private static final long serialVersionUID = -3753413284642976683L;
    private static final String KEY = Check.class.getName();
    @Visualizable
    private final Set<Spec> mSpec;
    private final Function<Spec, String> mPosMsgProvider;
    private final Function<Spec, String> mNegMsgProvider;

    public Check(Spec spec) {
        this(EnumSet.of(spec));
    }

    public Check(Spec spec, Function<Spec, String> funPositiveMessageProvider, Function<Spec, String> funNegativeMessageProvider) {
        this(EnumSet.of(spec), funPositiveMessageProvider, funNegativeMessageProvider);
    }

    public Check(Set<Spec> newSpec) {
        this(newSpec, Check::getDefaultPositiveMessage, Check::getDefaultNegativeMessage);
    }

    public Check(Set<Spec> newSpec, Function<Spec, String> funPositiveMessageProvider, Function<Spec, String> funNegativeMessageProvider) {
        assert (!newSpec.isEmpty());
        this.mSpec = newSpec;
        this.mPosMsgProvider = funPositiveMessageProvider;
        this.mNegMsgProvider = funNegativeMessageProvider;
    }

    public Set<Spec> getSpec() {
        return this.mSpec;
    }

    public String getPositiveMessage() {
        return this.getMessage(this.mPosMsgProvider);
    }

    public String getNegativeMessage() {
        return this.getMessage(this.mNegMsgProvider);
    }

    private String getMessage(Function<Spec, String> funMessageProvider) {
        Iterator<Spec> iter = this.mSpec.iterator();
        if (this.mSpec.size() == 1) {
            return funMessageProvider.apply(iter.next());
        }
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(funMessageProvider.apply(iter.next())).append(MSG_AND);
        }
        sb.delete(sb.length() - MSG_AND.length(), sb.length());
        return sb.toString();
    }

    public static String getDefaultPositiveMessage(Spec spec) {
        switch (spec) {
            case ARRAY_INDEX: {
                return "array index is always in bounds";
            }
            case PRE_CONDITION: {
                return "procedure precondition always holds";
            }
            case POST_CONDITION: {
                return "procedure postcondition always holds";
            }
            case INVARIANT: {
                return "loop invariant is valid";
            }
            case ASSERT: {
                return "assertion always holds";
            }
            case DIVISION_BY_ZERO: {
                return "division by zero can never occur";
            }
            case INTEGER_OVERFLOW: {
                return "integer overflow can never occur";
            }
            case MEMORY_DEREFERENCE: {
                return "pointer dereference always succeeds";
            }
            case MEMORY_LEAK: {
                return "all allocated memory was freed";
            }
            case MEMORY_FREE: {
                return "free always succeeds";
            }
            case MALLOC_NONNEGATIVE: {
                return "input of malloc is always non-negative";
            }
            case ILLEGAL_POINTER_ARITHMETIC: {
                return "pointer arithmetic is always legal";
            }
            case ERROR_FUNCTION: {
                return "call to the error function is unreachable";
            }
            case WITNESS_INVARIANT: {
                return "invariant of correctness witness holds";
            }
            case UNKNOWN: {
                return "unknown kind of specification holds";
            }
            case UINT_OVERFLOW: {
                return "there are no unsigned integer over- or underflows";
            }
            case UNDEFINED_BEHAVIOR: {
                return "there is no undefined behavior";
            }
            case RTINCONSISTENT: {
                return "rt-consistent";
            }
            case VACUOUS: {
                return "non-vacuous";
            }
            case CONSISTENCY: {
                return "consistent";
            }
            case INCOMPLETE: {
                return "complete";
            }
            case SUFFICIENT_THREAD_INSTANCES: {
                return "petrification did provide enough thread instances (tool internal message, not intended for end users)";
            }
            case DATA_RACE: {
                return "there are no data races";
            }
            case CHC_SATISFIABILITY: {
                return "the set of constraint Horn clauses is satisfiable";
            }
        }
        return "a specification is correct but has no positive message: " + (Object)((Object)spec);
    }

    public static String getDefaultNegativeMessage(Spec spec) {
        switch (spec) {
            case ARRAY_INDEX: {
                return "array index can be out of bounds";
            }
            case PRE_CONDITION: {
                return "procedure precondition can be violated";
            }
            case POST_CONDITION: {
                return "procedure postcondition can be violated";
            }
            case INVARIANT: {
                return "loop invariant can be violated";
            }
            case ASSERT: {
                return "assertion can be violated";
            }
            case DIVISION_BY_ZERO: {
                return "possible division by zero";
            }
            case INTEGER_OVERFLOW: {
                return "integer overflow possible";
            }
            case MEMORY_DEREFERENCE: {
                return "pointer dereference may fail";
            }
            case MEMORY_LEAK: {
                return "not all allocated memory was freed";
            }
            case MEMORY_FREE: {
                return "free of unallocated memory possible";
            }
            case MALLOC_NONNEGATIVE: {
                return "input of malloc can be negative";
            }
            case ILLEGAL_POINTER_ARITHMETIC: {
                return "comparison of incompatible pointers";
            }
            case ERROR_FUNCTION: {
                return "a call to the error function is reachable";
            }
            case WITNESS_INVARIANT: {
                return "invariant of correctness witness can be violated";
            }
            case UNKNOWN: {
                return "unknown kind of specification may be violated";
            }
            case UINT_OVERFLOW: {
                return "an unsigned integer over- or underflow may occur";
            }
            case UNDEFINED_BEHAVIOR: {
                return "undefined behavior may occur";
            }
            case RTINCONSISTENT: {
                return "rt-inconsistent";
            }
            case VACUOUS: {
                return "vacuous";
            }
            case CONSISTENCY: {
                return "inconsistent";
            }
            case INCOMPLETE: {
                return "incomplete";
            }
            case SUFFICIENT_THREAD_INSTANCES: {
                return "petrification did not provide enough thread instances (tool internal message, not intended for end users)";
            }
            case DATA_RACE: {
                return "the program contains a data race";
            }
            case CHC_SATISFIABILITY: {
                return "the set of constraint Horn clauses is unsatisfiable";
            }
        }
        return "a specification may be violated but has no negative message: " + (Object)((Object)spec);
    }

    public IAnnotations merge(IAnnotations other) {
        if (other == null) {
            return this;
        }
        if (other == this) {
            return this;
        }
        if (!(other instanceof Check)) {
            throw new IAnnotations.UnmergeableAnnotationsException((IAnnotations)this, other);
        }
        Check otherCheck = (Check)other;
        EnumSet<Spec> newSpec = EnumSet.copyOf(this.mSpec);
        newSpec.addAll(otherCheck.getSpec());
        return new Check(newSpec);
    }

    public void annotate(IElement node) {
        node.getPayload().getAnnotations().put(KEY, this);
    }

    public static Check getAnnotation(IElement node) {
        return (Check)ModelUtils.getAnnotation((IElement)node, (String)KEY, a -> (Check)a);
    }

    public static Check mergeCheck(Check one, Check other) {
        if (one == null) {
            return other;
        }
        if (other == null) {
            return one;
        }
        return (Check)one.merge(other);
    }

    public String toString() {
        return this.mSpec.stream().map(Enum::toString).collect(Collectors.joining(MSG_AND));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Check other = (Check)obj;
        return !(this.mSpec == null ? other.mSpec != null : !this.mSpec.equals(other.mSpec));
    }

    public static enum Spec {
        ARRAY_INDEX,
        PRE_CONDITION,
        POST_CONDITION,
        INVARIANT,
        ASSERT,
        DIVISION_BY_ZERO,
        INTEGER_OVERFLOW,
        MEMORY_DEREFERENCE,
        MEMORY_LEAK,
        MEMORY_FREE,
        MALLOC_NONNEGATIVE,
        ILLEGAL_POINTER_ARITHMETIC,
        ERROR_FUNCTION,
        UNKNOWN,
        LTL,
        WITNESS_INVARIANT,
        UINT_OVERFLOW,
        UNDEFINED_BEHAVIOR,
        RTINCONSISTENT,
        VACUOUS,
        CONSISTENCY,
        INCOMPLETE,
        SUFFICIENT_THREAD_INSTANCES,
        DATA_RACE,
        CHC_SATISFIABILITY;

    }
}

