/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public final class DataRaceAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = 1L;
    private static final String KEY = DataRaceAnnotation.class.getName();
    private final Set<Race> mRaces;

    private DataRaceAnnotation(Race race) {
        this(Set.of(race));
    }

    private DataRaceAnnotation(Set<Race> races) {
        this.mRaces = races;
    }

    public Set<Race> getRaces() {
        return Collections.unmodifiableSet(this.mRaces);
    }

    public IAnnotations merge(IAnnotations other) {
        if (other == null || other == this) {
            return this;
        }
        if (other instanceof DataRaceAnnotation) {
            return new DataRaceAnnotation(DataStructureUtils.union(this.mRaces, ((DataRaceAnnotation)other).mRaces));
        }
        return super.merge(other);
    }

    public static Race annotateAccess(IElement node, String accessPath, ILocation loc, boolean isWrite) {
        Race race = new Race(isWrite, accessPath, null, loc);
        node.getPayload().getAnnotations().put(KEY, new DataRaceAnnotation(race));
        return race;
    }

    public static void annotateCheck(IElement node, Race[] twinAccesses, ILocation loc) {
        boolean isWrite = twinAccesses[0].isWrite();
        String variable = twinAccesses[0].mAccessPath;
        node.getPayload().getAnnotations().put(KEY, new DataRaceAnnotation(new Race(isWrite, variable, twinAccesses, loc)));
    }

    public static DataRaceAnnotation getAnnotation(IElement node) {
        return (DataRaceAnnotation)ModelUtils.getAnnotation((IElement)node, (String)KEY, DataRaceAnnotation.class::cast);
    }

    public static final class Race {
        private final boolean mIsWrite;
        private final String mAccessPath;
        private final Set<Race> mTwinAccesses;
        private final ILocation mOriginalLocation;

        private Race(boolean isWrite, String accessPath, Race[] twinAccesses, ILocation location) {
            this.mIsWrite = isWrite;
            this.mAccessPath = accessPath;
            this.mTwinAccesses = twinAccesses == null ? null : Set.of(twinAccesses);
            this.mOriginalLocation = location;
        }

        public boolean isTwin(Race other) {
            if (this.isCheck()) {
                return this.mTwinAccesses.contains(other);
            }
            if (other.isCheck()) {
                return other.mTwinAccesses.contains(this);
            }
            return false;
        }

        public Optional<Boolean> isConflictingAccess(Race other) {
            if (!this.isCheck()) {
                throw new UnsupportedOperationException("Conflicting accesses can only be found for data race checks");
            }
            if (!this.isWrite() && !other.isWrite() || this.mTwinAccesses.contains(other)) {
                return Optional.of(false);
            }
            if (other.isCheck()) {
                return Optional.of(false);
            }
            if (this.isUndeterminedRace() || other.isUndeterminedRace()) {
                return Optional.empty();
            }
            return Optional.of(this.mAccessPath.startsWith(other.mAccessPath) || other.mAccessPath.startsWith(this.mAccessPath));
        }

        public String getVariable() {
            if (this.mAccessPath == null) {
                throw new IllegalStateException("heap race has no variable");
            }
            return this.mAccessPath;
        }

        public boolean isWrite() {
            return this.mIsWrite;
        }

        public boolean isCheck() {
            return this.mTwinAccesses != null;
        }

        public boolean isUndeterminedRace() {
            return this.mAccessPath == null;
        }

        public ILocation getOriginalLocation() {
            return this.mOriginalLocation;
        }
    }
}

