/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;

public class LoopEntryAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = 1L;
    private static final String KEY = LoopEntryAnnotation.class.getName();
    @Visualizable
    private final LoopEntryType mType;

    public LoopEntryAnnotation(LoopEntryType loopEntryType) {
        this.mType = loopEntryType;
    }

    public LoopEntryType getLoopEntryType() {
        return this.mType;
    }

    public void annotate(IElement node) {
        node.getPayload().getAnnotations().put(KEY, this);
    }

    public static LoopEntryAnnotation getAnnotation(IElement node) {
        return (LoopEntryAnnotation)ModelUtils.getAnnotation((IElement)node, (String)KEY, a -> (LoopEntryAnnotation)a);
    }

    public String toString() {
        return this.mType.toString();
    }

    public IAnnotations merge(IAnnotations other) {
        if (other instanceof LoopEntryAnnotation) {
            LoopEntryAnnotation otherLoopEntry = (LoopEntryAnnotation)other;
            if (otherLoopEntry.mType.equals((Object)this.mType)) {
                return this;
            }
            return new LoopEntryAnnotation(LoopEntryType.UNKNOWN);
        }
        return super.merge(other);
    }

    public static enum LoopEntryType {
        GOTO,
        WHILE,
        UNKNOWN;

    }
}

