/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;

public class LoopExitAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = 1L;
    private static final String KEY = LoopExitAnnotation.class.getName();
    @Visualizable
    private final LoopExitType mType;

    public LoopExitAnnotation(LoopExitType loopEntryType) {
        this.mType = loopEntryType;
    }

    public LoopExitType getLoopExitType() {
        return this.mType;
    }

    public void annotate(IElement node) {
        node.getPayload().getAnnotations().put(KEY, this);
    }

    public static LoopExitAnnotation getAnnotation(IElement node) {
        return (LoopExitAnnotation)ModelUtils.getAnnotation((IElement)node, (String)KEY, a -> (LoopExitAnnotation)a);
    }

    public IAnnotations merge(IAnnotations other) {
        if (other instanceof LoopExitAnnotation) {
            LoopExitAnnotation otherLoopExit = (LoopExitAnnotation)other;
            if (otherLoopExit.mType.equals((Object)this.mType)) {
                return this;
            }
            return new LoopExitAnnotation(LoopExitType.UNKNOWN);
        }
        return super.merge(other);
    }

    public String toString() {
        return this.mType.toString();
    }

    public static enum LoopExitType {
        BREAK,
        RETURN,
        GOTO,
        WHILE,
        UNKNOWN;

    }
}

