/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DefaultLocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MergedLocation
extends DefaultLocation {
    private static final String MSG_UNKNOWN = "UNKNOWN";
    private static final long serialVersionUID = 1L;
    private final List<ILocation> mOriginLocations;

    private MergedLocation(String fileName, int startLine, int endLine, int startColum, int endColumn, List<ILocation> origins) {
        super(fileName, startLine, endLine, startColum, endColumn);
        this.mOriginLocations = Objects.requireNonNull(origins);
    }

    @Visualizable
    public List<ILocation> getOriginLocations() {
        return Collections.unmodifiableList(this.mOriginLocations);
    }

    public IAnnotations merge(IAnnotations other) {
        if (other instanceof MergedLocation) {
            MergedLocation otherMergedLoc = (MergedLocation)other;
            ArrayList<ILocation> mergedOrigins = new ArrayList<ILocation>();
            mergedOrigins.addAll(this.getOriginLocations());
            mergedOrigins.addAll(otherMergedLoc.getOriginLocations());
            return MergedLocation.mergeNonMergeLocation(this, otherMergedLoc, mergedOrigins);
        }
        if (other instanceof ILocation) {
            return MergedLocation.mergeToMergeLocation(this, (ILocation)other);
        }
        return super.merge(other);
    }

    private static ILocation mergeNonMergeLocation(ILocation loc, ILocation otherLoc, List<ILocation> origins) {
        int endColumn;
        int startColum;
        int endLine;
        int startLine;
        String fileName;
        if (Objects.equals(loc.getFileName(), otherLoc.getFileName())) {
            fileName = loc.getFileName();
            Pair<Integer, Integer> newLines = MergedLocation.mergeInterval(loc.getStartLine(), loc.getEndLine(), otherLoc.getStartLine(), otherLoc.getEndLine());
            Pair<Integer, Integer> newColumns = MergedLocation.mergeInterval(loc.getStartColumn(), loc.getEndColumn(), otherLoc.getStartColumn(), otherLoc.getEndColumn());
            startLine = (Integer)newLines.getFirst();
            endLine = (Integer)newLines.getSecond();
            startColum = (Integer)newColumns.getFirst();
            endColumn = (Integer)newColumns.getSecond();
        } else {
            fileName = MSG_UNKNOWN;
            startLine = -1;
            endLine = -1;
            startColum = -1;
            endColumn = -1;
        }
        return new MergedLocation(fileName, startLine, endLine, startColum, endColumn, origins);
    }

    public static Pair<Integer, Integer> mergeInterval(int aLower, int aUpper, int bLower, int bUpper) {
        int newFirst = aLower < 0 || bLower < 0 ? -1 : (aLower <= bLower ? aLower : bLower);
        int newSecond = aUpper < 0 || bUpper < 0 ? -1 : (aUpper <= bUpper ? bUpper : aUpper);
        return new Pair((Object)newFirst, (Object)newSecond);
    }

    public static ILocation mergeToMergeLocation(ILocation one, ILocation other) {
        if (one == null) {
            return other;
        }
        if (other == null) {
            return one;
        }
        if (one instanceof MergedLocation && other instanceof MergedLocation) {
            return (ILocation)one.merge((IAnnotations)other);
        }
        ArrayList<ILocation> origins = new ArrayList<ILocation>(2);
        origins.add(one);
        origins.add(other);
        return MergedLocation.mergeNonMergeLocation(one, other, origins);
    }

    @Override
    public String toString() {
        return "Merged: " + this.getOriginLocations().stream().map(a -> a.toString()).collect(Collectors.joining(", "));
    }
}

