/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Overapprox
extends ModernAnnotations {
    private static final long serialVersionUID = -575969312624287029L;
    public static final String BITVEC = "bitvector operation";
    public static final String BITSHIFT_OVERFLOW = "overflow check for bitwise shift operation";
    public static final String FUNC_POINTER = "call of function pointer";
    @Visualizable
    private final Map<String, ILocation> mReason2Loc;

    public Overapprox(Map<String, ILocation> reason2Loc) {
        this.mReason2Loc = reason2Loc;
    }

    public Overapprox(String reason, ILocation loc) {
        this(Collections.singletonMap(reason, loc));
    }

    @Visualizable
    private Set<String> getReasonForOverapproximation() {
        return this.mReason2Loc.keySet();
    }

    public Map<String, ILocation> getOverapproximatedLocations() {
        return this.mReason2Loc;
    }

    public static Map<String, ILocation> getOverapproximations(List<? extends IElement> trace) {
        HashMap<String, ILocation> result = new HashMap<String, ILocation>();
        for (IElement iElement : trace) {
            Overapprox overapprox = Overapprox.getAnnotation(iElement);
            if (overapprox == null) continue;
            result.putAll(overapprox.getOverapproximatedLocations());
        }
        return result;
    }

    public static <TE extends IElement> Map<String, ILocation> getOverapproximations(IProgramExecution<TE, ?> pe) {
        HashMap<String, ILocation> result = new HashMap<String, ILocation>();
        Iterator iter = pe.iterator();
        while (iter.hasNext()) {
            IElement current = (IElement)((AtomicTraceElement)iter.next()).getTraceElement();
            Overapprox overapprox = Overapprox.getAnnotation(current);
            if (overapprox == null) continue;
            result.putAll(overapprox.getOverapproximatedLocations());
        }
        return result;
    }

    public String toString() {
        return "Overapprox: " + this.mReason2Loc;
    }

    public IAnnotations annotate(IElement elem) {
        return elem.getPayload().getAnnotations().put(Overapprox.class.getName(), this);
    }

    public static Overapprox getAnnotation(IElement node) {
        return (Overapprox)ModelUtils.getAnnotation((IElement)node, (String)Overapprox.class.getName(), a -> (Overapprox)a);
    }

    public IAnnotations merge(IAnnotations other) {
        if (other == this || other == null) {
            return this;
        }
        if (!(other instanceof Overapprox)) {
            return super.merge(other);
        }
        Overapprox otheroverapprox = (Overapprox)other;
        HashMap<String, ILocation> newReasons = new HashMap<String, ILocation>(this.mReason2Loc);
        for (Map.Entry<String, ILocation> entry : otheroverapprox.mReason2Loc.entrySet()) {
            ILocation iLocation = newReasons.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return new Overapprox(newReasons);
    }
}

