/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import java.util.List;

public class AnnotationCheckResult<ELEM extends IElement, EXPR>
extends AbstractResult
implements IResultWithSeverity {
    final IBacktranslationService mTranslatorSequence;
    private final List<LoopFreeSegment<ELEM>> mSegmentsValid;
    private final List<LoopFreeSegment<ELEM>> mSegmentsUnknown;
    private final List<LoopFreeSegmentWithStatePair<ELEM, EXPR>> mSegmentsInvalid;
    private final AnnotationState mAnnotationState;

    public AnnotationCheckResult(String plugin, IBacktranslationService translatorSequence, List<LoopFreeSegment<ELEM>> segmentsValid, List<LoopFreeSegment<ELEM>> segmentsUnknown, List<LoopFreeSegmentWithStatePair<ELEM, EXPR>> segmentsInvalid) {
        super(plugin);
        this.mTranslatorSequence = translatorSequence;
        this.mSegmentsValid = segmentsValid;
        this.mSegmentsUnknown = segmentsUnknown;
        this.mSegmentsInvalid = segmentsInvalid;
        this.mAnnotationState = this.determineAnnotationState(segmentsValid, segmentsUnknown, segmentsInvalid);
    }

    private AnnotationState determineAnnotationState(List<LoopFreeSegment<ELEM>> segmentsValid, List<LoopFreeSegment<ELEM>> segmentsUnknown, List<LoopFreeSegmentWithStatePair<ELEM, EXPR>> segmentsInvalid) {
        AnnotationState result = segmentsInvalid.isEmpty() ? (segmentsUnknown.isEmpty() ? AnnotationState.VALID : AnnotationState.UNKNOWN) : AnnotationState.INVALID;
        return result;
    }

    public IResultWithSeverity.Severity getSeverity() {
        switch (this.mAnnotationState) {
            case VALID: {
                return IResultWithSeverity.Severity.INFO;
            }
            case UNKNOWN: 
            case INVALID: {
                return IResultWithSeverity.Severity.ERROR;
            }
        }
        throw new AssertionError((Object)("Unknown value " + (Object)((Object)this.mAnnotationState)));
    }

    public String getShortDescription() {
        String result;
        switch (this.mAnnotationState) {
            case INVALID: {
                result = "Annotation is not a valid proof of correctness.";
                break;
            }
            case UNKNOWN: {
                result = "Insufficient resources for checking whether annotation is a valid proof of correctness";
                break;
            }
            case VALID: {
                result = "Annotation is a valid proof of correctness";
                break;
            }
            default: {
                throw new AssertionError((Object)("illegal value " + (Object)((Object)this.mAnnotationState)));
            }
        }
        return result;
    }

    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortDescription());
        sb.append(System.lineSeparator());
        for (LoopFreeSegmentWithStatePair<ELEM, EXPR> loopFreeSegmentWithStatePair : this.mSegmentsInvalid) {
            sb.append(AnnotationCheckResult.invalidSegmentToString(loopFreeSegmentWithStatePair, this.mTranslatorSequence));
            sb.append(System.lineSeparator());
        }
        for (LoopFreeSegment loopFreeSegment : this.mSegmentsUnknown) {
            sb.append(AnnotationCheckResult.unknownSegmentToString(loopFreeSegment));
            sb.append(System.lineSeparator());
        }
        for (LoopFreeSegment loopFreeSegment : this.mSegmentsValid) {
            sb.append(AnnotationCheckResult.validSegmentToString(loopFreeSegment));
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static <E> String validSegmentToString(LoopFreeSegment<E> segment) {
        return "Annotation is valid for " + segment + ".";
    }

    public static <E> String unknownSegmentToString(LoopFreeSegment<E> segment) {
        return "Insufficient resources for checking whether annotation is valid for " + segment + ".";
    }

    public static <ELEM, E> String invalidSegmentToString(LoopFreeSegmentWithStatePair<ELEM, E> segment, IBacktranslationService translation) {
        return "Annotation is not valid for " + segment + ". One counterexample starts in " + translation.translateProgramStateToString(segment.getStateBefore()) + " and ends in " + translation.translateProgramStateToString(segment.getStateAfter()) + ".";
    }

    public static enum AnnotationState {
        VALID,
        UNKNOWN,
        INVALID;

    }

    public static abstract class CategorizedProgramPoint {
        private final ILocation mLocation;

        public CategorizedProgramPoint(ILocation location) {
            this.mLocation = location;
        }

        protected ILocation getLocation() {
            return this.mLocation;
        }
    }

    public static class CheckPoint
    extends CategorizedProgramPoint {
        final Check mCheck;

        public CheckPoint(ILocation location, Check check) {
            super(location);
            this.mCheck = check;
        }

        public String toString() {
            return "check that " + this.mCheck.getPositiveMessage() + " at line " + this.getLocation().getStartLine();
        }
    }

    public static class LoopFreeSegment<E> {
        final CategorizedProgramPoint mCppBefore;
        final CategorizedProgramPoint mCppAfter;

        public LoopFreeSegment(CategorizedProgramPoint cppBefore, CategorizedProgramPoint cppAfter) {
            this.mCppBefore = cppBefore;
            this.mCppAfter = cppAfter;
        }

        public String toString() {
            return "all loop-free paths from " + this.mCppBefore + " to " + this.mCppAfter;
        }
    }

    public static class LoopFreeSegmentWithStatePair<ELEM, E>
    extends LoopFreeSegment<ELEM> {
        final IProgramExecution.ProgramState<E> mStateBefore;
        final IProgramExecution.ProgramState<E> mStateAfter;

        public LoopFreeSegmentWithStatePair(CategorizedProgramPoint cppBefore, CategorizedProgramPoint cppAfter, IProgramExecution.ProgramState<E> stateBefore, IProgramExecution.ProgramState<E> stateAfter) {
            super(cppBefore, cppAfter);
            this.mStateBefore = stateBefore;
            this.mStateAfter = stateAfter;
        }

        public IProgramExecution.ProgramState<E> getStateBefore() {
            return this.mStateBefore;
        }

        public IProgramExecution.ProgramState<E> getStateAfter() {
            return this.mStateAfter;
        }
    }

    public static class LoopHead
    extends CategorizedProgramPoint {
        public LoopHead(ILocation location) {
            super(location);
        }

        public String toString() {
            return "loop head at line " + this.getLocation().getStartLine();
        }
    }

    public static class ProcedureEntry
    extends CategorizedProgramPoint {
        final String mProcedureName;

        public ProcedureEntry(ILocation location, String procedureName) {
            super(location);
            this.mProcedureName = procedureName;
        }

        public String toString() {
            return "entry of procedure " + this.mProcedureName;
        }
    }

    public static class ProcedureExit
    extends CategorizedProgramPoint {
        final String mProcedureName;

        public ProcedureExit(ILocation location, String procedureName) {
            super(location);
            this.mProcedureName = procedureName;
        }

        public String toString() {
            return "exit of procedure " + this.mProcedureName;
        }
    }
}

