/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;

public class AutomataScriptInterpreterOverallResult
extends AbstractResult
implements IResultWithSeverity {
    private final OverallResult mOverallResult;
    private final String mErrorMessage;

    public AutomataScriptInterpreterOverallResult(String plugin, OverallResult overallResult, String errorMessage) {
        super(plugin);
        if (errorMessage == null && overallResult == OverallResult.EXCEPTION_OR_ERROR) {
            throw new UnsupportedOperationException("provide error message if there was an error");
        }
        if (errorMessage != null && overallResult != OverallResult.EXCEPTION_OR_ERROR && overallResult != OverallResult.TIMEOUT) {
            throw new UnsupportedOperationException("provide error message only if there was an error or timeout");
        }
        this.mOverallResult = overallResult;
        this.mErrorMessage = errorMessage;
    }

    public String getShortDescription() {
        switch (this.mOverallResult) {
            case ALL_ASSERTIONS_HOLD: {
                return "Finished interpretation of automata script.";
            }
            case EXCEPTION_OR_ERROR: {
                return "Interpretation of automata script failed.";
            }
            case NO_ASSERTION: {
                return "Finished interpretation of automata script.";
            }
            case SOME_ASSERTION_FAILED: {
                return "Some assert statements have been evaluated to false.";
            }
            case TIMEOUT: {
                return "Timeout during interpretation of automata script.";
            }
            case OUT_OF_MEMORY: {
                return "Run out of memory during interpretation of automata script.";
            }
        }
        throw new AssertionError((Object)"unknown case");
    }

    public String getLongDescription() {
        switch (this.mOverallResult) {
            case ALL_ASSERTIONS_HOLD: {
                return "All assert statements have been evaluated to true.";
            }
            case NO_ASSERTION: {
                return " You have not used any assert statement in your automata script. Assert statements can be used to check Boolean results.";
            }
        }
        return this.getShortDescription();
    }

    public IResultWithSeverity.Severity getSeverity() {
        switch (this.mOverallResult) {
            case ALL_ASSERTIONS_HOLD: {
                return IResultWithSeverity.Severity.INFO;
            }
            case EXCEPTION_OR_ERROR: {
                return IResultWithSeverity.Severity.ERROR;
            }
            case NO_ASSERTION: {
                return IResultWithSeverity.Severity.INFO;
            }
            case SOME_ASSERTION_FAILED: {
                return IResultWithSeverity.Severity.ERROR;
            }
            case TIMEOUT: {
                return IResultWithSeverity.Severity.WARNING;
            }
            case OUT_OF_MEMORY: {
                return IResultWithSeverity.Severity.WARNING;
            }
        }
        throw new AssertionError((Object)"unknown case");
    }

    public OverallResult getOverallResult() {
        return this.mOverallResult;
    }

    public String getErrorMessage() {
        if (this.mErrorMessage == null) {
            throw new UnsupportedOperationException("there is no error message, because there was no error");
        }
        return this.mErrorMessage;
    }

    public static enum OverallResult {
        ALL_ASSERTIONS_HOLD,
        NO_ASSERTION,
        SOME_ASSERTION_FAILED,
        EXCEPTION_OR_ERROR,
        TIMEOUT,
        OUT_OF_MEMORY;

    }
}

