/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.IResultWithCheck;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithFiniteTrace;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.List;

public class CounterExampleResult<ELEM extends IElement, TE extends IElement, E>
extends AbstractResultAtElement<ELEM>
implements IResultWithFiniteTrace<TE, E>,
IResultWithCheck {
    private final Check mCheckedSpecification;
    private String mProgramExecutionAsString;
    private final List<ILocation> mFailurePath;
    private final IProgramExecution<TE, E> mProgramExecution;

    public CounterExampleResult(ELEM position, String plugin, IBacktranslationService translatorSequence, IProgramExecution<TE, E> pe) {
        super(position, plugin, translatorSequence);
        this.mCheckedSpecification = Check.getAnnotation(position);
        this.mProgramExecution = pe;
        this.mFailurePath = ResultUtil.getLocationSequence(pe);
    }

    private CounterExampleResult(CounterExampleResult<ELEM, TE, E> old) {
        super(old.getElement(), old.getPlugin(), old.mTranslatorSequence);
        this.mCheckedSpecification = old.mCheckedSpecification;
        this.mProgramExecution = IProgramExecution.emptyExecution((Class)old.mProgramExecution.getExpressionClass(), (Class)old.mProgramExecution.getTraceElementClass());
        this.mFailurePath = old.mFailurePath;
        this.mProgramExecutionAsString = "";
    }

    public String getShortDescription() {
        if (this.mCheckedSpecification == null) {
            return "some specification is violated - ERROR (information lost during translation process)";
        }
        return this.mCheckedSpecification.getNegativeMessage();
    }

    @Override
    public Check getCheckedSpecification() {
        return this.mCheckedSpecification;
    }

    private boolean isRelevanceInformationIncluded() {
        if (this.getProgramExecution().getLength() > 0) {
            return this.getProgramExecution().getTraceElement(0).getRelevanceInformation() != null;
        }
        return false;
    }

    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortDescription());
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append("We found a FailurePath: ");
        sb.append(CoreUtil.getPlatformLineSeparator());
        if (this.isRelevanceInformationIncluded()) {
            sb.append("(The third column contains information about the relevance of the program statement.");
            sb.append(" The asterisk (*) means that the statement's code block is 'error enforcing'.");
            sb.append(" The at sign (@) means that the statement's code block is 'error admitting'.");
            sb.append(" The dash (-) means that the statement's code block is irrelevant.)");
            sb.append(CoreUtil.getPlatformLineSeparator());
        }
        sb.append(this.getProgramExecutionAsString());
        return sb.toString();
    }

    public List<ILocation> getFailurePath() {
        return this.mFailurePath;
    }

    public IProgramExecution<TE, E> getProgramExecution() {
        return this.mProgramExecution;
    }

    public String getProgramExecutionAsString() {
        if (this.mProgramExecutionAsString == null) {
            this.mProgramExecutionAsString = this.mTranslatorSequence.translateProgramExecution(this.mProgramExecution).toString();
        }
        return this.mProgramExecutionAsString;
    }

    public CounterExampleResult<ELEM, TE, E> createCounterExampleResultWithoutTrace() {
        return new CounterExampleResult<ELEM, TE, E>(this);
    }
}

