/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.Map;
import java.util.Set;

public class DangerInvariantResult<LOC, TERM>
extends AbstractResult {
    private final Map<LOC, TERM> mInvariants;
    private final Set<LOC> mErrorLocations;
    private final IBacktranslationService mBacktranslator;

    public DangerInvariantResult(String plugin, Map<LOC, TERM> invariants, Set<LOC> errorLocations, IBacktranslationService backtranslator) {
        super(plugin);
        this.mInvariants = invariants;
        this.mErrorLocations = errorLocations;
        this.mBacktranslator = backtranslator;
    }

    public String getShortDescription() {
        return "Danger Invariant";
    }

    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Derived danger invariant for the following error locations: ");
        sb.append(this.mErrorLocations);
        for (Map.Entry<LOC, TERM> entry : this.mInvariants.entrySet()) {
            sb.append(CoreUtil.getPlatformLineSeparator());
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(this.mBacktranslator.translateExpressionToString(entry.getValue(), entry.getValue().getClass()));
        }
        return sb.toString();
    }
}

