/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DataRaceAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithFiniteTrace;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DataRaceFoundResult<ELEM extends IElement, TE extends IElement, E>
extends AbstractResultAtElement<ELEM>
implements IResultWithFiniteTrace<TE, E> {
    private final IProgramExecution<TE, E> mProgramExecution;
    private final List<ILocation> mFailurePath;
    private final DataRaceAnnotation mRaceAnnotation;
    private final HashRelation<DataRaceAnnotation.Race, DataRaceAnnotation.Race> mPossibleConflicts;

    public DataRaceFoundResult(ELEM position, String plugin, IBacktranslationService translatorSequence, IProgramExecution<TE, E> execution) {
        super(position, plugin, translatorSequence);
        this.mRaceAnnotation = DataRaceAnnotation.getAnnotation(position);
        assert (this.mRaceAnnotation != null);
        this.mPossibleConflicts = this.findPossibleViolations(this.mRaceAnnotation, execution);
        assert (this.mPossibleConflicts.size() > 0);
        this.mProgramExecution = execution;
        this.mFailurePath = ResultUtil.getLocationSequence(execution);
    }

    private HashRelation<DataRaceAnnotation.Race, DataRaceAnnotation.Race> findPossibleViolations(DataRaceAnnotation annotation, IProgramExecution<TE, E> execution) {
        HashRelation result = new HashRelation();
        int i = execution.getLength() - 2;
        while (i >= 0) {
            DataRaceAnnotation current = DataRaceAnnotation.getAnnotation((IElement)execution.getTraceElement(i).getStep());
            if (current != null) {
                for (DataRaceAnnotation.Race race : annotation.getRaces()) {
                    for (DataRaceAnnotation.Race other : current.getRaces()) {
                        Optional<Boolean> conflict = race.isConflictingAccess(other);
                        if (conflict.orElse(false).booleanValue()) {
                            HashRelation definite = new HashRelation();
                            definite.addPair((Object)race, (Object)other);
                            return definite;
                        }
                        if (!conflict.isEmpty()) continue;
                        result.addPair((Object)race, (Object)other);
                    }
                }
            }
            --i;
        }
        return result;
    }

    public String getShortDescription() {
        return "Data race detected";
    }

    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortDescription());
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append("The following path leads to a data race: ");
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append(this.mTranslatorSequence.translateProgramExecution(this.mProgramExecution).toString());
        sb.append(CoreUtil.getPlatformLineSeparator());
        if (this.mPossibleConflicts.size() == 1) {
            Map.Entry definite = (Map.Entry)this.mPossibleConflicts.getSetOfPairs().iterator().next();
            DataRaceFoundResult.formatDefiniteRace(sb, (DataRaceAnnotation.Race)definite.getKey(), (DataRaceAnnotation.Race)definite.getValue());
        } else {
            sb.append("Now there is a data race, but we were unable to determine exactly which statements and variables are involved.");
            for (Map.Entry entry : this.mPossibleConflicts.entrySet()) {
                DataRaceFoundResult.formatPossibleRace(sb, (DataRaceAnnotation.Race)entry.getKey(), (Set)entry.getValue());
            }
        }
        return sb.toString();
    }

    private static void formatDefiniteRace(StringBuilder sb, DataRaceAnnotation.Race check, DataRaceAnnotation.Race access) {
        sb.append("Now there is a data race ");
        if (check.isUndeterminedRace()) {
            sb.append("(on the heap)");
        } else {
            sb.append("on ");
            sb.append(access.getVariable());
        }
        sb.append(" between ");
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append("\t");
        sb.append(access.getOriginalLocation());
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append("and");
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append("\t");
        sb.append(check.getOriginalLocation());
        sb.append(CoreUtil.getPlatformLineSeparator());
    }

    private static void formatPossibleRace(StringBuilder sb, DataRaceAnnotation.Race check, Set<DataRaceAnnotation.Race> accesses) {
        assert (!accesses.isEmpty());
        sb.append(" There could be a race between");
        if (accesses.size() == 1) {
            sb.append(CoreUtil.getPlatformLineSeparator());
            sb.append("\t");
            sb.append(accesses.iterator().next().getOriginalLocation());
            sb.append(CoreUtil.getPlatformLineSeparator());
        } else {
            sb.append(" one of the statements");
            sb.append(CoreUtil.getPlatformLineSeparator());
            for (DataRaceAnnotation.Race access : accesses) {
                sb.append("\t* ");
                sb.append(access.getOriginalLocation());
                sb.append(CoreUtil.getPlatformLineSeparator());
            }
        }
        sb.append("and");
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append("\t");
        sb.append(check.getOriginalLocation());
        sb.append(CoreUtil.getPlatformLineSeparator());
    }

    public List<ILocation> getFailurePath() {
        return this.mFailurePath;
    }

    public IProgramExecution<TE, E> getProgramExecution() {
        return this.mProgramExecution;
    }
}

