/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainExceptionWrapper;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IFailedAnalysisResult;

public class ExceptionOrErrorResult
extends AbstractResult
implements IFailedAnalysisResult {
    private final Throwable mThrowable;

    public ExceptionOrErrorResult(String plugin, Throwable throwable) {
        super(ExceptionOrErrorResult.getPluginName(plugin, throwable));
        this.mThrowable = throwable instanceof ToolchainExceptionWrapper ? ((ToolchainExceptionWrapper)throwable).getCause() : throwable;
    }

    private static String getPluginName(String plugin, Throwable throwable) {
        if (throwable instanceof ToolchainExceptionWrapper) {
            return ((ToolchainExceptionWrapper)throwable).getPluginId();
        }
        return plugin;
    }

    public String getShortDescription() {
        return String.valueOf(this.mThrowable.getClass().getSimpleName()) + ": " + this.mThrowable.getMessage();
    }

    public String getLongDescription() {
        StackTraceElement[] stacktrace = this.mThrowable.getStackTrace();
        String rtr = String.valueOf(this.getPlugin()) + ": " + this.getShortDescription();
        if (stacktrace != null && stacktrace.length > 0) {
            rtr = String.valueOf(rtr) + ": " + stacktrace[0].toString();
        }
        return rtr;
    }

    @Override
    public String toString() {
        return this.getLongDescription();
    }
}

