/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;

public class ExternalWitnessValidationResult
extends AbstractResult {
    private final IResult mResult;
    private final String mWitness;
    private final WitnessVerificationStatus mVerificationStatus;
    private final WitnessVerificationStatus mExpectedVerificationStatus;

    public ExternalWitnessValidationResult(String pluginId, IResult result, String witness, WitnessVerificationStatus verificationStatus, WitnessVerificationStatus expectedVerificationStatus) {
        super(pluginId);
        this.mResult = result;
        this.mWitness = witness;
        this.mVerificationStatus = verificationStatus;
        this.mExpectedVerificationStatus = expectedVerificationStatus;
    }

    public String getShortDescription() {
        if (this.isEmpty()) {
            return "No witness for: " + this.mResult.getShortDescription();
        }
        switch (this.getVerificationStatus()) {
            case INTERNAL_ERROR: {
                return "An error occured during witness verification for: " + this.mResult.getShortDescription();
            }
            case UNVERIFIED: {
                return "Unverified witness for: " + this.mResult.getShortDescription();
            }
            case VERIFICATION_FAILED: {
                return "Witness verification failed for: " + this.mResult.getShortDescription();
            }
            case VERIFIED: {
                return "Verified witness for: " + this.mResult.getShortDescription();
            }
        }
        throw new UnsupportedOperationException("Enum value " + (Object)((Object)this.getVerificationStatus()) + " is unhandled");
    }

    public String getLongDescription() {
        return this.getShortDescription();
    }

    public WitnessVerificationStatus getVerificationStatus() {
        return this.mVerificationStatus;
    }

    public WitnessVerificationStatus getExpectedVerificationStatus() {
        return this.mExpectedVerificationStatus;
    }

    public IResult getAffectedResult() {
        return this.mResult;
    }

    public boolean isEmpty() {
        return this.mWitness == null;
    }

    public static enum WitnessVerificationStatus {
        VERIFIED,
        UNVERIFIED,
        VERIFICATION_FAILED,
        INTERNAL_ERROR;

    }
}

