/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.LassoShapedNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeometricNonTerminationArgumentResult<P extends IElement, E>
extends LassoShapedNonTerminationArgument<P, E> {
    private static final int SCHEMATIC_EXECUTION_LENGTH = 3;
    private static final boolean ALTERNATIVE_LONG_DESCRIPTION = true;
    private final Map<E, Rational> mStateInit;
    private final Map<E, Rational> mStateHonda;
    private final List<Map<E, Rational>> mRays;
    private final List<Rational> mLambdas;
    private final List<Rational> mNus;

    public GeometricNonTerminationArgumentResult(P position, String plugin, Map<E, Rational> stateInit, Map<E, Rational> stateHonda, List<Map<E, Rational>> rays, List<Rational> lambdas, List<Rational> nus, IBacktranslationService translatorSequence, Class<E> exprClazz, IProgramExecution<P, E> stem, IProgramExecution<P, E> loop) {
        super(position, plugin, translatorSequence, exprClazz, stem, loop);
        this.mStateInit = stateInit;
        this.mStateHonda = stateHonda;
        this.mRays = rays;
        this.mLambdas = lambdas;
        this.mNus = nus;
        assert (this.mRays.size() == this.mLambdas.size());
    }

    @Override
    public String getShortDescription() {
        return "Nontermination argument in form of an infinite program execution.";
    }

    public String getLongDescription() {
        return this.alternativeLongDesciption();
    }

    public String defaultLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Nontermination argument in form of an infinite execution\n");
        sb.append(this.mStateInit);
        Rational[] geometric_sum = new Rational[this.mLambdas.size()];
        int i = 0;
        while (i < this.mLambdas.size()) {
            geometric_sum[i] = Rational.ZERO;
            ++i;
        }
        int j = 0;
        while (j < 3) {
            HashMap<E, String> state = new HashMap<E, String>();
            for (E var : this.mStateHonda.keySet()) {
                Rational x = this.mStateHonda.get(var);
                int i2 = 0;
                while (i2 < this.mRays.size()) {
                    Rational y = this.mRays.get(i2).get(var);
                    if (y != null) {
                        x = x.add(y.mul(geometric_sum[i2]));
                    }
                    ++i2;
                }
                state.put(var, x.toString());
            }
            int i3 = this.mRays.size() - 1;
            while (i3 >= 0) {
                geometric_sum[i3] = geometric_sum[i3].mul(this.mLambdas.get(i3)).add(Rational.ONE);
                if (i3 > 0) {
                    geometric_sum[i3] = geometric_sum[i3].add(geometric_sum[i3 - 1].mul(this.mNus.get(i3 - 1)));
                }
                --i3;
            }
            sb.append("\n");
            sb.append(this.printState(state));
            ++j;
        }
        return sb.toString();
    }

    private String alternativeLongDesciption() {
        StringBuilder sb = new StringBuilder();
        sb.append("Nontermination argument in form of an infinite execution\n");
        sb.append("State at position 0 is\n");
        HashMap<E, String> statePos0 = new HashMap<E, String>();
        for (Map.Entry<E, Rational> entry : this.mStateInit.entrySet()) {
            Object var = entry.getKey();
            Rational x0 = this.mStateInit.get(var);
            statePos0.put(var, x0.toString());
        }
        sb.append(this.printState(statePos0));
        sb.append("\nState at position 1 is\n");
        HashMap statePos1 = new HashMap();
        for (Map.Entry entry : this.mStateHonda.entrySet()) {
            Object var = entry.getKey();
            Rational x = this.mStateHonda.get(var);
            statePos1.put(var, x.toString());
        }
        sb.append(this.printState(statePos1));
        sb.append("\nFor i>1, the state at position i is\n");
        HashMap<E, String> hashMap = new HashMap<E, String>();
        for (Object var : this.mStateHonda.keySet()) {
            StringBuilder sb2 = new StringBuilder();
            Rational x = this.mStateHonda.get(var);
            int i = 0;
            while (i < this.mRays.size()) {
                Rational y = this.mRays.get(i).get(var);
                if (y != null && !y.equals((Object)Rational.ZERO)) {
                    if (sb2.length() > 0) {
                        sb2.append(" + ");
                    }
                    int j = 0;
                    while (j <= i && j < this.mRays.size()) {
                        boolean ok = true;
                        int s = i - j;
                        while (s < i) {
                            if (this.mNus.get(s).equals((Object)Rational.ZERO)) {
                                ok = false;
                            }
                            ++s;
                        }
                        if (ok) {
                            if (j > 0) {
                                sb2.append(" + ");
                            }
                            Rational lambda = this.mLambdas.get(i - j);
                            sb2.append(y);
                            if (j == 1) {
                                sb2.append("*k");
                            } else if (j > 1) {
                                sb2.append("*binomial(k, " + j + ")");
                            }
                            if (!lambda.equals((Object)Rational.ONE)) {
                                if (j == 0) {
                                    sb2.append("*" + lambda + "^k");
                                } else {
                                    sb2.append("*" + lambda + "^(k-" + j + ")");
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (sb2.length() == 0) {
                sb2.append("0");
            }
            hashMap.put(var, String.valueOf(x.toString()) + " + sum_{k=0}^i " + sb2.toString());
        }
        sb.append(this.printState(hashMap));
        return sb.toString();
    }
}

