/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;

public class InsufficientAnnotationResult<ELEM extends IElement, E>
extends AbstractResultAtElement<ELEM> {
    final ILocation mLocationBefore;
    final ILocation mLocationAfter;
    final IProgramExecution.ProgramState<E> mStateBefore;
    final IProgramExecution.ProgramState<E> mStateAfter;

    public InsufficientAnnotationResult(ELEM positionBefore, String plugin, IBacktranslationService translatorSequence, ELEM positionAfter, IProgramExecution.ProgramState<E> stateBefore, IProgramExecution.ProgramState<E> stateAfter) {
        super(positionBefore, plugin, translatorSequence);
        this.mLocationBefore = ILocation.getAnnotation(positionBefore);
        this.mLocationAfter = ILocation.getAnnotation(positionAfter);
        if (this.mLocationBefore == null) {
            throw new UnsupportedOperationException("position does not have a location");
        }
        if (this.mLocationAfter == null) {
            throw new UnsupportedOperationException("position does not have a location");
        }
        this.mStateBefore = stateBefore;
        this.mStateAfter = stateAfter;
    }

    public String getShortDescription() {
        return "Annotation between " + this.mLocationBefore.getStartLine() + " and " + this.mLocationAfter.getStartLine() + " is not inductive";
    }

    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortDescription());
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append("Counterexample state before: ");
        sb.append(this.mTranslatorSequence.translateProgramStateToString(this.mStateBefore));
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append("Counterexample state after: ");
        sb.append(this.mTranslatorSequence.translateProgramStateToString(this.mStateAfter));
        return sb.toString();
    }
}

