/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithLocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;

public class InvariantResult<ELEM extends IElement, E>
extends AbstractResultAtElement<ELEM>
implements IResultWithLocation {
    private final E mInvariant;

    public InvariantResult(String plugin, ELEM element, IBacktranslationService translatorSequence, E invariant) {
        super(element, plugin, translatorSequence);
        this.mInvariant = invariant;
    }

    public E getInvariant() {
        return this.mInvariant;
    }

    public String getShortDescription() {
        return "Loop Invariant";
    }

    public String getLongDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Derived loop invariant: ");
        sb.append(this.mTranslatorSequence.translateExpressionToString(this.mInvariant, this.mInvariant.getClass()));
        return sb.toString();
    }
}

