/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.NonterminatingLassoResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;

public class LTLInfiniteCounterExampleResult<ELEM extends IElement, TE extends IElement, E>
extends NonterminatingLassoResult<ELEM, TE, E> {
    private final String mLTLProperty;

    public LTLInfiniteCounterExampleResult(ELEM position, String plugin, IBacktranslationService translatorSequence, IProgramExecution<TE, E> stem, IProgramExecution<TE, E> loop, String ltlproperty) {
        super(position, plugin, translatorSequence, stem, loop);
        this.mLTLProperty = ltlproperty;
    }

    @Override
    public String getShortDescription() {
        return "Violation of LTL property " + this.mLTLProperty;
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Found an infinite, lasso-shaped execution that violates the LTL property ");
        sb.append(this.mLTLProperty);
        sb.append(".");
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append("Stem:");
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append(this.mTranslatorSequence.translateProgramExecution(this.mStem));
        sb.append("Loop:");
        sb.append(CoreUtil.getPlatformLineSeparator());
        sb.append(this.mTranslatorSequence.translateProgramExecution(this.mLoop));
        sb.append("End of lasso representation.");
        return sb.toString();
    }
}

