/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class NonTerminationArgumentResult<P extends IElement, E>
extends AbstractResultAtElement<P> {
    private final Class<E> mExprClazz;

    public NonTerminationArgumentResult(P element, String plugin, IBacktranslationService translatorSequence, Class<E> exprClass) {
        super(element, plugin, translatorSequence);
        this.mExprClazz = exprClass;
    }

    public String getShortDescription() {
        return "Nontermination argument in form of an infinite program execution.";
    }

    protected String printState(Map<E, String> state) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (Map.Entry<E, String> entry : state.entrySet()) {
            String var = this.mTranslatorSequence.translateExpressionToString(entry.getKey(), this.mExprClazz);
            if (var.contains("UnsupportedOperation")) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(var);
            sb.append("=");
            sb.append(entry.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    protected String printState2(Map<E, E> state) {
        IProgramExecution.ProgramState programState = new IProgramExecution.ProgramState(state.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> Set.of(x.getValue()))), this.mExprClazz);
        return "{" + this.mTranslatorSequence.translateProgramStateToString(programState) + "}";
    }
}

