/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithInfiniteLassoTrace;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;

public class NonterminatingLassoResult<ELEM extends IElement, TE extends IElement, EXP>
extends AbstractResultAtElement<ELEM>
implements IResultWithInfiniteLassoTrace<TE, EXP> {
    protected final IProgramExecution<TE, EXP> mStem;
    protected final IProgramExecution<TE, EXP> mLoop;

    public NonterminatingLassoResult(ELEM position, String plugin, IBacktranslationService translatorSequence, IProgramExecution<TE, EXP> stem, IProgramExecution<TE, EXP> loop) {
        super(position, plugin, translatorSequence);
        this.mStem = stem;
        this.mLoop = loop;
    }

    public String getShortDescription() {
        return "Nonterminating execution";
    }

    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Found a nonterminating execution for the following lasso shaped sequence of statements.");
        sb.append(System.getProperty("line.separator"));
        sb.append("Stem:");
        sb.append(System.getProperty("line.separator"));
        sb.append(this.mTranslatorSequence.translateProgramExecution(this.mStem));
        sb.append("Loop:");
        sb.append(System.getProperty("line.separator"));
        sb.append(this.mTranslatorSequence.translateProgramExecution(this.mLoop));
        sb.append("End of lasso representation.");
        return sb.toString();
    }

    public IProgramExecution<TE, EXP> getStem() {
        return this.mStem;
    }

    public IProgramExecution<TE, EXP> getLasso() {
        return this.mLoop;
    }
}

