/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.IResultWithCheck;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;

public class PositiveResult<ELEM extends IElement>
extends AbstractResultAtElement<ELEM>
implements IResultWithCheck {
    private final Check mCheckedSpecification;

    public PositiveResult(String plugin, ELEM position, IBacktranslationService translatorSequence) {
        super(position, plugin, translatorSequence);
        this.mCheckedSpecification = Check.getAnnotation(position);
    }

    public String getShortDescription() {
        if (this.mCheckedSpecification == null) {
            return "some specification holds - ERROR (information lost during translation process)";
        }
        return this.mCheckedSpecification.getPositiveMessage();
    }

    public String getLongDescription() {
        if (this.mCheckedSpecification == null) {
            return "some specification holds - ERROR (information lost during translation process)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("For all program executions holds that ");
        sb.append(this.mCheckedSpecification.getPositiveMessage());
        sb.append(" at this location");
        return sb.toString();
    }

    @Override
    public Check getCheckedSpecification() {
        return this.mCheckedSpecification;
    }
}

