/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithLocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;

public class ProcedureContractResult<ELEM extends IElement, E>
extends AbstractResultAtElement<ELEM>
implements IResultWithLocation {
    private final E mContract;
    private final String mProcedureName;

    public ProcedureContractResult(String plugin, ELEM position, IBacktranslationService translatorSequence, String procedureName, E contract) {
        super(position, plugin, translatorSequence);
        this.mProcedureName = procedureName;
        this.mContract = contract;
    }

    public E getContract() {
        return this.mContract;
    }

    public String getShortDescription() {
        return "Procedure Contract for " + this.mProcedureName;
    }

    public String getLongDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Derived contract for procedure ");
        sb.append(this.mProcedureName);
        sb.append(": ");
        sb.append(this.mTranslatorSequence.translateExpressionToString(this.mContract, this.mContract.getClass()));
        return sb.toString();
    }
}

